/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ec2.domain.IpProtocol;

public class IpPermission {
    private final int fromPort;
    private final int toPort;
    private final Multimap<String, String> userIdGroupPairs;
    private final Set<String> groupIds;
    private final IpProtocol ipProtocol;
    private final Set<String> ipRanges;

    public static Builder builder() {
        return new Builder();
    }

    public IpPermission(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> userIdGroupPairs, Iterable<String> groupIds, Iterable<String> ipRanges) {
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.userIdGroupPairs = ImmutableMultimap.copyOf(Preconditions.checkNotNull(userIdGroupPairs, "userIdGroupPairs"));
        this.ipProtocol = Preconditions.checkNotNull(ipProtocol, "ipProtocol");
        this.groupIds = ImmutableSet.copyOf(Preconditions.checkNotNull(groupIds, "groupIds"));
        this.ipRanges = ImmutableSet.copyOf(Preconditions.checkNotNull(ipRanges, "ipRanges"));
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public Multimap<String, String> getUserIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    public Set<String> getIpRanges() {
        return this.ipRanges;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.fromPort, this.toPort, this.groupIds, this.ipProtocol, this.ipRanges, this.userIdGroupPairs});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IpPermission that = (IpPermission)IpPermission.class.cast(obj);
        return Objects.equal(this.fromPort, that.fromPort) && Objects.equal(this.toPort, that.toPort) && Objects.equal(this.groupIds, that.groupIds) && Objects.equal((Object)this.ipProtocol, (Object)that.ipProtocol) && Objects.equal(this.ipRanges, that.ipRanges) && Objects.equal(this.userIdGroupPairs, that.userIdGroupPairs);
    }

    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("fromPort", this.fromPort == -1 ? null : Integer.valueOf(this.fromPort)).add("toPort", this.toPort == -1 ? null : Integer.valueOf(this.toPort)).add("groupIds", this.groupIds.size() == 0 ? null : this.groupIds).add("ipProtocol", (Object)this.ipProtocol).add("ipRanges", this.ipRanges.size() == 0 ? null : this.ipRanges).add("userIdGroupPairs", this.userIdGroupPairs.size() == 0 ? null : this.userIdGroupPairs).toString();
    }

    public static class Builder {
        private int fromPort;
        private int toPort;
        private IpProtocol ipProtocol;
        private Multimap<String, String> userIdGroupPairs = LinkedHashMultimap.create();
        private Set<String> groupIds = Sets.newLinkedHashSet();
        private Set<String> ipRanges = Sets.newLinkedHashSet();

        public Builder fromPort(int fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public Builder toPort(int toPort) {
            this.toPort = toPort;
            return this;
        }

        public Builder ipProtocol(IpProtocol ipProtocol) {
            this.ipProtocol = Preconditions.checkNotNull(ipProtocol, "ipProtocol");
            return this;
        }

        public Builder userIdGroupPair(String userId, String groupNameOrId) {
            this.userIdGroupPairs.put(Preconditions.checkNotNull(userId, "userId"), Preconditions.checkNotNull(groupNameOrId, "groupNameOrId of %s", userId));
            return this;
        }

        public Builder userIdGroupPairs(Multimap<String, String> userIdGroupPairs) {
            this.userIdGroupPairs.putAll(Preconditions.checkNotNull(userIdGroupPairs, "userIdGroupPairs"));
            return this;
        }

        public Builder ipRange(String ipRange) {
            this.ipRanges.add(ipRange);
            return this;
        }

        public Builder ipRanges(Iterable<String> ipRanges) {
            Iterables.addAll(this.ipRanges, Preconditions.checkNotNull(ipRanges, "ipRanges"));
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupIds.add(Preconditions.checkNotNull(groupId, "groupId"));
            return this;
        }

        public Builder groupIds(Iterable<String> groupIds) {
            Iterables.addAll(this.groupIds, Preconditions.checkNotNull(groupIds, "groupIds"));
            return this;
        }

        public IpPermission build() {
            return new IpPermission(this.ipProtocol, this.fromPort, this.toPort, this.userIdGroupPairs, this.groupIds, this.ipRanges);
        }
    }
}

