/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.encryption.internal.Base64;

@Beta
public class InputSuppliers {
    public static Base64InputSupplier base64Encoder(InputSupplier<? extends InputStream> supplier) throws IOException {
        return new Base64InputSupplier(supplier, 9);
    }

    public static Base64InputSupplier base64Decoder(InputSupplier<? extends InputStream> supplier) throws IOException {
        return new Base64InputSupplier(supplier, 0);
    }

    public static InputSupplier<? extends InputStream> of(final InputStream in) {
        Preconditions.checkNotNull(in, "in");
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                return in;
            }
        };
    }

    public static InputSupplier<? extends InputStream> of(byte[] in) {
        return ByteStreams.newInputStreamSupplier(Preconditions.checkNotNull(in, "in"));
    }

    public static InputSupplier<? extends InputStream> of(String in) {
        return InputSuppliers.of(Preconditions.checkNotNull(in, "in").getBytes(Charsets.UTF_8));
    }

    @VisibleForTesting
    static class Base64InputSupplier
    implements InputSupplier<InputStream> {
        private final InputSupplier<? extends InputStream> delegate;
        private final int mode;

        Base64InputSupplier(InputSupplier<? extends InputStream> inputSupplier, int mode) {
            this.delegate = Preconditions.checkNotNull(inputSupplier, "delegate");
            this.mode = mode;
        }

        @Override
        public InputStream getInput() throws IOException {
            return new Base64.InputStream(this.delegate.getInput(), this.mode);
        }
    }
}

