/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

public class IgnoreNullSetTypeAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (typeToken.getRawType() != Set.class || !(type instanceof ParameterizedType)) {
            return null;
        }
        Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
        TypeAdapter<?> elementAdapter = gson.getAdapter(TypeToken.get(elementType));
        return this.newSetAdapter(elementAdapter);
    }

    protected <E> TypeAdapter<Set<E>> newSetAdapter(final TypeAdapter<E> elementAdapter) {
        return new TypeAdapter<Set<E>>(){

            @Override
            public void write(JsonWriter out, Set<E> value) throws IOException {
                out.beginArray();
                for (Object element : value) {
                    elementAdapter.write(out, element);
                }
                out.endArray();
            }

            @Override
            public Set<E> read(JsonReader in) throws IOException {
                ImmutableSet.Builder result = ImmutableSet.builder();
                in.beginArray();
                while (in.hasNext()) {
                    Object element = elementAdapter.read(in);
                    if (element == null) continue;
                    result.add(element);
                }
                in.endArray();
                return result.build();
            }
        }.nullSafe();
    }
}

