/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;

@Singleton
public class RegionToEndpointOrProviderIfNull
implements Function<Object, URI> {
    private final Supplier<URI> defaultUri;
    private final String defaultProvider;
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    public RegionToEndpointOrProviderIfNull(@Provider String defaultProvider, @Provider Supplier<URI> defaultUri, @Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.defaultProvider = Preconditions.checkNotNull(defaultProvider, "defaultProvider");
        this.defaultUri = Preconditions.checkNotNull(defaultUri, "defaultUri");
        this.regionToEndpointSupplier = Preconditions.checkNotNull(regionToEndpointSupplier, "regionToEndpointSupplier");
    }

    @Override
    public URI apply(@Nullable Object from) {
        if (from == null) {
            return this.defaultUri.get();
        }
        Preconditions.checkArgument(from instanceof String, "region is a String argument");
        Map<String, Supplier<URI>> regionToEndpoint = this.regionToEndpointSupplier.get();
        if (from.equals(this.defaultProvider)) {
            if (regionToEndpoint.containsKey(from)) {
                return regionToEndpoint.get(from).get();
            }
            return this.defaultUri.get();
        }
        Preconditions.checkArgument(regionToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, regionToEndpoint);
        return regionToEndpoint.get(from).get();
    }
}

