/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Zone;

@Singleton
public class ZoneToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> zoneToEndpointSupplier;

    @Inject
    public ZoneToEndpoint(@Zone Supplier<Map<String, Supplier<URI>>> zoneToEndpointSupplier) {
        this.zoneToEndpointSupplier = Preconditions.checkNotNull(zoneToEndpointSupplier, "zoneToEndpointSupplier");
    }

    @Override
    public URI apply(@Nullable Object from) {
        Preconditions.checkArgument(from != null && from instanceof String, "you must specify a zone, as a String argument");
        Map<String, Supplier<URI>> zoneToEndpoint = this.zoneToEndpointSupplier.get();
        Preconditions.checkState(zoneToEndpoint.size() > 0, "no zone name to endpoint mappings configured!");
        Preconditions.checkArgument(zoneToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, zoneToEndpoint);
        return zoneToEndpoint.get(from).get();
    }
}

