/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ovf.Property;
import org.jclouds.ovf.Section;

public class ProductSection
extends Section<ProductSection> {
    protected final Set<Property> properties;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ProductSection.builder().fromDeploymentOptionSection(this);
    }

    public ProductSection(String info, Iterable<Property> properties) {
        super(info);
        this.properties = ImmutableSet.copyOf(Preconditions.checkNotNull(properties, "properties"));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.properties == null ? 0 : ((Object)this.properties).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductSection other = (ProductSection)obj;
        return !(this.properties == null ? other.properties != null : !((Object)this.properties).equals(other.properties));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, properties=%s]", this.info, this.properties);
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public static class Builder
    extends Section.Builder<ProductSection> {
        protected Set<Property> properties = Sets.newLinkedHashSet();

        public Builder property(Property property) {
            this.properties.add(Preconditions.checkNotNull(property, "property"));
            return this;
        }

        public Builder properties(Iterable<Property> properties) {
            this.properties = ImmutableSet.copyOf(Preconditions.checkNotNull(properties, "properties"));
            return this;
        }

        public ProductSection build() {
            return new ProductSection(this.info, this.properties);
        }

        public Builder fromDeploymentOptionSection(ProductSection in) {
            return this.info(in.getInfo()).properties(in.getProperties());
        }

        public Builder fromSection(Section<ProductSection> in) {
            return (Builder)Builder.class.cast(super.fromSection(in));
        }

        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

