package com.xebialabs.deployit.plugin.ec2.task.delegates;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.ec2.steps.DestroyInstanceStep;
import com.xebialabs.deployit.plugin.ec2.steps.UnregisterInstanceStep;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;

import static com.google.common.collect.Lists.newArrayList;

public class InstanceDelegates {

    @Delegate(name="destroyEC2Instance")
    public static List<? extends Step> destroy(ConfigurationItem ci, String method, Map<String, String> params) {
        return newArrayList(
                new DestroyInstanceStep(ci, new ServiceFactory()),
                new UnregisterInstanceStep(ci.getId())
        );
    }

}
