/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.io.payloads.BasePayload;
import org.jclouds.io.payloads.Part;

public class MultipartForm
extends BasePayload<Iterable<? extends Part>> {
    public static final String BOUNDARY = "--JCLOUDS--";
    private static final String rn = "\r\n";
    private static final String dd = "--";
    private boolean isRepeatable;
    private final InputSupplier<? extends InputStream> chain;

    public MultipartForm(String boundary, Iterable<? extends Part> content) {
        super(content);
        this.getContentMetadata().setContentType("multipart/form-data; boundary=" + boundary);
        this.getContentMetadata().setContentLength(0L);
        String boundaryrn = boundary + rn;
        this.isRepeatable = true;
        InputSupplier<InputStream> chain = ByteStreams.join(new InputSupplier[0]);
        for (Part part : content) {
            if (!part.isRepeatable()) {
                this.isRepeatable = false;
            }
            this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + part.getContentMetadata().getContentLength());
            chain = ByteStreams.join(chain, this.addLengthAndReturnHeaders(boundaryrn, part), part, this.addLengthAndReturnRn());
        }
        chain = ByteStreams.join(chain, this.addLengthAndReturnFooter(boundary));
        this.chain = chain;
    }

    public MultipartForm(String boundary, Part ... parts) {
        this(boundary, Lists.newArrayList(parts));
    }

    public MultipartForm(Part ... parts) {
        this(BOUNDARY, parts);
    }

    private InputSupplier<? extends InputStream> addLengthAndReturnRn() {
        this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + (long)rn.length());
        return ByteStreams.newInputStreamSupplier(rn.getBytes());
    }

    private InputSupplier<? extends InputStream> addLengthAndReturnHeaders(String boundaryrn, Part part) {
        StringBuilder builder = new StringBuilder(dd).append(boundaryrn);
        for (Map.Entry<String, String> entry : part.getHeaders().entries()) {
            String header = String.format("%s: %s%s", entry.getKey(), entry.getValue(), rn);
            builder.append(header);
        }
        builder.append(rn);
        this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + (long)builder.length());
        return ByteStreams.newInputStreamSupplier(builder.toString().getBytes());
    }

    private InputSupplier<? extends InputStream> addLengthAndReturnFooter(String boundary) {
        String end = dd + boundary + dd + rn;
        this.getContentMetadata().setContentLength(this.getContentMetadata().getContentLength() + (long)end.length());
        return ByteStreams.newInputStreamSupplier(end.getBytes());
    }

    @Override
    public InputStream getInput() {
        try {
            return this.chain.getInput();
        }
        catch (IOException e) {
            Throwables.propagate(e);
            return null;
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Override
    public void release() {
        for (Part part : (Iterable)this.content) {
            part.release();
        }
    }
}

