/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.predicates.SocketOpen;

public class ConcurrentOpenSocketFinder
implements OpenSocketFinder {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final SocketOpen socketTester;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final ListeningExecutorService executor;

    @Inject
    public ConcurrentOpenSocketFinder(SocketOpen socketTester, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.user-threads") ExecutorService userThreads) {
        this.socketTester = socketTester;
        this.nodeRunning = nodeRunning;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)userThreads);
    }

    @Override
    public HostAndPort findOpenSocketOnNode(final NodeMetadata node, int port, long timeoutValue, TimeUnit timeUnits) {
        Iterable<String> hosts = this.checkNodeHasIps(node);
        Set<HostAndPort> sockets = this.toHostAndPorts(hosts, port);
        long period = timeUnits.convert(1L, TimeUnit.SECONDS);
        final AtomicReference result = new AtomicReference();
        Predicate<Collection<HostAndPort>> concurrentOpenSocketFinder = new Predicate<Collection<HostAndPort>>(){

            public boolean apply(Collection<HostAndPort> input) {
                HostAndPort reachableSocket = ConcurrentOpenSocketFinder.this.findOpenSocket(input);
                if (reachableSocket != null) {
                    result.set(reachableSocket);
                    return true;
                }
                if (ConcurrentOpenSocketFinder.this.nodeRunning != null && !ConcurrentOpenSocketFinder.this.nodeRunning.apply(new AtomicReference<NodeMetadata>(node))) {
                    throw new IllegalStateException(String.format("Node %s is no longer running; aborting waiting for ip:port connection", node.getId()));
                }
                return false;
            }
        };
        RetryablePredicate retryingOpenSocketFinder = new RetryablePredicate((Predicate)concurrentOpenSocketFinder, timeoutValue, period, timeUnits);
        this.logger.debug(">> blocking on sockets %s for %d %s", new Object[]{sockets, timeoutValue, timeUnits});
        boolean passed = retryingOpenSocketFinder.apply(sockets);
        if (passed) {
            this.logger.debug("<< socket %s opened", new Object[]{result});
            assert (result.get() != null);
            return (HostAndPort)result.get();
        }
        this.logger.warn("<< sockets %s didn't open after %d %s", new Object[]{sockets, timeoutValue, timeUnits});
        throw new NoSuchElementException(String.format("could not connect to any ip address port %d on node %s", port, node));
    }

    private HostAndPort findOpenSocket(final Collection<HostAndPort> sockets) {
        final AtomicReference result = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger completeCount = new AtomicInteger();
        for (final HostAndPort socket : sockets) {
            ListenableFuture future = this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ConcurrentOpenSocketFinder.this.socketTester.apply((Object)socket)) {
                            result.compareAndSet(null, socket);
                            latch.countDown();
                        }
                    }
                    catch (RuntimeException e) {
                        ConcurrentOpenSocketFinder.this.logger.warn((Throwable)e, "Error checking reachability of ip:port %s", new Object[]{socket});
                    }
                }
            });
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    if (completeCount.incrementAndGet() >= sockets.size()) {
                        latch.countDown();
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        return (HostAndPort)result.get();
    }

    private Iterable<String> checkNodeHasIps(NodeMetadata node) {
        Iterable ips = Iterables.concat(node.getPublicAddresses(), node.getPrivateAddresses());
        Preconditions.checkState((Iterables.size((Iterable)ips) > 0 ? 1 : 0) != 0, (Object)("node does not have IP addresses configured: " + node));
        return ips;
    }

    private Set<HostAndPort> toHostAndPorts(Iterable<String> hosts, final int port) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(hosts, (Function)new Function<String, HostAndPort>(){

            public HostAndPort apply(String from) {
                return HostAndPort.fromParts((String)from, (int)port);
            }
        }));
    }
}

