/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;

public class ExceptionToValueOrPropagate<E extends Exception, T>
implements Function<Exception, T> {
    private final Class<E> matchingClass;
    private final T value;

    public ExceptionToValueOrPropagate(Class<E> matchingClass, @Nullable T value) {
        this.matchingClass = (Class)Preconditions.checkNotNull(matchingClass, (Object)"matchingClass");
        this.value = value;
    }

    public T apply(Exception from) {
        Preconditions.checkNotNull((Object)from, (Object)"exception");
        List throwables = Throwables.getCausalChain((Throwable)from);
        Iterable matchingThrowables = Iterables.filter((Iterable)throwables, this.matchingClass);
        if (Iterables.size((Iterable)matchingThrowables) >= 1) {
            return this.value;
        }
        throw Throwables.propagate((Throwable)from);
    }
}

