/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.WriteTo;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class StreamingPayload
implements Payload {
    protected volatile transient boolean written;
    protected final WriteTo writeTo;
    protected MutableContentMetadata contentMetadata;

    public StreamingPayload(WriteTo writeTo) {
        this(writeTo, new BaseMutableContentMetadata());
    }

    protected StreamingPayload(WriteTo writeTo, MutableContentMetadata contentMetadata) {
        this.writeTo = (WriteTo)Preconditions.checkNotNull((Object)writeTo, (Object)"writeTo");
        this.contentMetadata = (MutableContentMetadata)Preconditions.checkNotNull((Object)contentMetadata, (Object)"contentMetadata");
    }

    @Override
    public Object getRawContent() {
        throw new UnsupportedOperationException("this payload is for streaming writes only");
    }

    @Override
    public InputStream getInput() {
        throw new UnsupportedOperationException("this payload is for streaming writes only");
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.writeTo.writeTo(outstream);
    }

    public String toString() {
        return "[contentMetadata=" + this.contentMetadata + ", written=" + this.written + "]";
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentMetadata == null ? 0 : this.contentMetadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamingPayload other = (StreamingPayload)obj;
        return !(this.contentMetadata == null ? other.contentMetadata != null : !this.contentMetadata.equals(other.contentMetadata));
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata in) {
        this.contentMetadata = in;
    }
}

