/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.util.Predicates2;

@Singleton
public class EncodedRSAPublicKeyToBase64
implements Function<Object, String> {
    private static final Predicate<String> ALLOWED_MARKERS = Predicates.or((Predicate[])new Predicate[]{Predicates2.startsWith((String)"ssh-rsa"), Predicates2.startsWith((String)"-----BEGIN CERTIFICATE-----"), Predicates2.startsWith((String)"---- BEGIN SSH2 PUBLIC KEY ----")});

    public String apply(Object from) {
        Preconditions.checkNotNull((Object)from, (Object)"input");
        String fromString = from.toString();
        Preconditions.checkArgument((boolean)ALLOWED_MARKERS.apply((Object)fromString), (String)"must be a ssh public key, conforming to %s ", (Object[])new Object[]{ALLOWED_MARKERS});
        return CryptoStreams.base64((byte[])fromString.getBytes(Charsets.UTF_8));
    }
}

