package com.xebialabs.deployit.plugin.ec2.util;

import java.io.Serializable;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;

import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;

@SuppressWarnings("serial")
public class ServiceFactory implements Serializable {

    public ComputeService getComputeService(String key, String secret) {
        ComputeServiceContext computeServiceContext = ContextBuilder.newBuilder("aws-ec2").
                credentials(key, secret).
                buildView(ComputeServiceContext.class);

        return computeServiceContext.getComputeService();
    }

    public EC2Adapter getEC2Adapter(Credentials credentials) {
        return new EC2Adapter(credentials);
    }

}
