/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.step.WaitForInstancesStep;
import com.xebialabs.deployit.plugin.cloud.util.MarkerChecker;
import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.steps.CreateInstanceStep;
import com.xebialabs.deployit.plugin.ec2.steps.DestroyInstanceStep;
import com.xebialabs.deployit.plugin.ec2.util.EC2InstanceType;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

@Metadata(description="Amazon EC2 instance template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class HostTemplate
extends BaseHostTemplate {
    @Property(required=true, label="EC2 credentials", description="The EC2 credentials to use when communicating with the AWS API.")
    private Credentials credentials;
    @Property(required=true, label="Groups", description="The EC2 security groups to associate with the instance.")
    private Set<String> groups;
    @Property(required=true, label="Image id (AMI)", description="The Amazon Machine Image ID (AMI) to use when creating an instance.")
    private String ami;
    @Property(required=true, label="Region", description="The EC2 region to create the instance in (e.g., us-west-1 or eu-west-1)")
    private String region;
    @Property(required=true, label="Instance type", description="The EC2 instance type to create.")
    private EC2InstanceType instanceType;
    @Property(required=true, label="Key pair", description="Name of the EC2 key pair to use. It should be already present on EC2.")
    private String keyPair;

    public EC2InstanceType getInstanceType() {
        return this.instanceType;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getAmi() {
        return this.ami;
    }

    public String getRegion() {
        return this.region;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setInstanceType(EC2InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public List<? extends Step> produceCreateSteps(String name, int instanceSeq) {
        String instanceLabel = instanceSeq == 0 ? name : name + " (" + this.getName() + ") #" + instanceSeq;
        return Arrays.asList(new CreateInstanceStep(this, new EC2Adapter(this.getCredentials()), instanceLabel), new WaitForInstancesStep(new MarkerChecker()));
    }

    public List<? extends Step> produceDestroySteps(ConfigurationItem instance) {
        return Arrays.asList(new DestroyInstanceStep(instance, new ServiceFactory()));
    }

    public String getInstanceIpAddress(String cloudId) {
        try {
            return new EC2Adapter(this.getCredentials()).waitUntilInstanceIsRunning(this.getRegion(), cloudId, this.getBootTimeout(), this.getRetryDelay());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

