/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Maps2;

@Singleton
public class BaseComputeService
implements ComputeService {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final ComputeServiceContext context;
    protected final Map<String, Credentials> credentialStore;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwareProfiles;
    private final Supplier<Set<? extends Location>> locations;
    private final GetImageStrategy getImageStrategy;
    private final ListNodesStrategy listNodesStrategy;
    private final GetNodeMetadataStrategy getNodeMetadataStrategy;
    private final CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy;
    private final RebootNodeStrategy rebootNodeStrategy;
    private final DestroyNodeStrategy destroyNodeStrategy;
    private final ResumeNodeStrategy resumeNodeStrategy;
    private final SuspendNodeStrategy suspendNodeStrategy;
    private final Provider<TemplateBuilder> templateBuilderProvider;
    private final Provider<TemplateOptions> templateOptionsProvider;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final Predicate<AtomicReference<NodeMetadata>> nodeTerminated;
    private final Predicate<AtomicReference<NodeMetadata>> nodeSuspended;
    private final InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory;
    private final ComputeServiceConstants.Timeouts timeouts;
    private final InitAdminAccess initAdminAccess;
    private final PersistNodeCredentials persistNodeCredentials;
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final ExecutorService executor;
    private final Optional<ImageExtension> imageExtension;

    @Inject
    protected BaseComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwareProfiles, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy resumeNodeStrategy, SuspendNodeStrategy suspendNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, InitAdminAccess initAdminAccess, RunScriptOnNode.Factory runScriptOnNodeFactory, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, Optional<ImageExtension> imageExtension) {
        this.context = (ComputeServiceContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwareProfiles = (Supplier)Preconditions.checkNotNull(hardwareProfiles, (Object)"hardwareProfiles");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.getNodeMetadataStrategy = (GetNodeMetadataStrategy)Preconditions.checkNotNull((Object)getNodeMetadataStrategy, (Object)"getNodeMetadataStrategy");
        this.listNodesStrategy = (ListNodesStrategy)Preconditions.checkNotNull((Object)listNodesStrategy, (Object)"listNodesStrategy");
        this.getImageStrategy = (GetImageStrategy)Preconditions.checkNotNull((Object)getImageStrategy, (Object)"getImageStrategy");
        this.runNodesAndAddToSetStrategy = (CreateNodesInGroupThenAddToSet)Preconditions.checkNotNull((Object)runNodesAndAddToSetStrategy, (Object)"runNodesAndAddToSetStrategy");
        this.rebootNodeStrategy = (RebootNodeStrategy)Preconditions.checkNotNull((Object)rebootNodeStrategy, (Object)"rebootNodeStrategy");
        this.resumeNodeStrategy = (ResumeNodeStrategy)Preconditions.checkNotNull((Object)resumeNodeStrategy, (Object)"resumeNodeStrategy");
        this.suspendNodeStrategy = (SuspendNodeStrategy)Preconditions.checkNotNull((Object)suspendNodeStrategy, (Object)"suspendNodeStrategy");
        this.destroyNodeStrategy = (DestroyNodeStrategy)Preconditions.checkNotNull((Object)destroyNodeStrategy, (Object)"destroyNodeStrategy");
        this.templateBuilderProvider = (Provider)Preconditions.checkNotNull(templateBuilderProvider, (Object)"templateBuilderProvider");
        this.templateOptionsProvider = (Provider)Preconditions.checkNotNull(templateOptionsProvider, (Object)"templateOptionsProvider");
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.nodeTerminated = (Predicate)Preconditions.checkNotNull(nodeTerminated, (Object)"nodeTerminated");
        this.nodeSuspended = (Predicate)Preconditions.checkNotNull(nodeSuspended, (Object)"nodeSuspended");
        this.initScriptRunnerFactory = (InitializeRunScriptOnNodeOrPlaceInBadMap.Factory)Preconditions.checkNotNull((Object)initScriptRunnerFactory, (Object)"initScriptRunnerFactory");
        this.timeouts = (ComputeServiceConstants.Timeouts)Preconditions.checkNotNull((Object)timeouts, (Object)"timeouts");
        this.initAdminAccess = (InitAdminAccess)Preconditions.checkNotNull((Object)initAdminAccess, (Object)"initAdminAccess");
        this.runScriptOnNodeFactory = (RunScriptOnNode.Factory)Preconditions.checkNotNull((Object)runScriptOnNodeFactory, (Object)"runScriptOnNodeFactory");
        this.persistNodeCredentials = (PersistNodeCredentials)Preconditions.checkNotNull((Object)persistNodeCredentials, (Object)"persistNodeCredentials");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.imageExtension = imageExtension;
    }

    @Override
    public ComputeServiceContext getContext() {
        return this.context;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Map executionExceptions;
        Preconditions.checkNotNull((Object)group, (Object)"group cannot be null");
        Preconditions.checkNotNull((Object)template.getLocation(), (Object)"location");
        this.logger.debug(">> running %d node%s group(%s) location(%s) image(%s) hardwareProfile(%s) options(%s)", new Object[]{count, count > 1 ? "s" : "", group, template.getLocation().getId(), template.getImage().getId(), template.getHardware().getId(), template.getOptions()});
        LinkedHashSet goodNodes = Sets.newLinkedHashSet();
        Map badNodes = Maps.newLinkedHashMap();
        LinkedHashMultimap customizationResponses = LinkedHashMultimap.create();
        if (template.getOptions().getRunScript() != null) {
            this.initAdminAccess.visit(template.getOptions().getRunScript());
        }
        Map<?, Future<Void>> responses = this.runNodesAndAddToSetStrategy.execute(group, count, template, goodNodes, badNodes, (Multimap<NodeMetadata, CustomizationResponse>)customizationResponses);
        try {
            executionExceptions = FutureIterables.awaitCompletion(responses, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("createNodesInGroup(" + group + ")"));
        }
        catch (TimeoutException te) {
            throw Throwables.propagate((Throwable)te);
        }
        Function<NodeMetadata, NodeMetadata> fn = this.persistNodeCredentials.always(template.getOptions().getRunScript());
        badNodes = Maps2.transformKeys((Map)badNodes, fn);
        goodNodes = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)goodNodes, fn));
        if (executionExceptions.size() > 0 || badNodes.size() > 0) {
            throw new RunNodesException(group, count, template, goodNodes, executionExceptions, badNodes);
        }
        return goodNodes;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateBuilder().any().options(templateOptions).build());
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateOptions());
    }

    @Override
    public void destroyNode(String id) {
        NodeMetadata destroyedNodeOrNull = this.doDestroyNode(id);
        if (destroyedNodeOrNull != null) {
            this.cleanUpIncidentalResourcesOfDeadNodes((Set<? extends NodeMetadata>)ImmutableSet.of((Object)destroyedNodeOrNull));
        }
    }

    @Override
    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> destroying nodes matching(%s)", new Object[]{filter});
        LinkedHashSet set = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), (Function)new Function<NodeMetadata, Future<? extends NodeMetadata>>(){

            public Future<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.executor.submit(new Callable<NodeMetadata>(){

                    @Override
                    @Nullable
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.doDestroyNode(from.getId());
                        return from;
                    }

                    public String toString() {
                        return "destroyNode(" + from.getId() + ")";
                    }
                });
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("destroyNodesMatching(" + filter + ")")), (Predicate)Predicates.notNull()));
        this.logger.debug("<< destroyed(%d)", new Object[]{set.size()});
        this.cleanUpIncidentalResourcesOfDeadNodes(set);
        return set;
    }

    @Nullable
    protected NodeMetadata doDestroyNode(final String id) {
        boolean successful;
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> destroying node(%s)", new Object[]{id});
        final AtomicReference node = new AtomicReference();
        RetryablePredicate tester = new RetryablePredicate((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    NodeMetadata md = BaseComputeService.this.destroyNodeStrategy.destroyNode(id);
                    if (md != null) {
                        node.set(md);
                    }
                    return true;
                }
                catch (IllegalStateException e) {
                    BaseComputeService.this.logger.warn("<< illegal state destroying node(%s)", new Object[]{id});
                    return false;
                }
            }
        }, this.timeouts.nodeTerminated, 1000L, TimeUnit.MILLISECONDS);
        boolean bl = successful = tester.apply((Object)id) && (node.get() == null || this.nodeTerminated.apply(node));
        if (successful) {
            this.credentialStore.remove("node#" + id);
        }
        this.logger.debug("<< destroyed node(%s) success(%s)", new Object[]{id, successful});
        return (NodeMetadata)node.get();
    }

    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminated(Predicate<NodeMetadata> filter) {
        return Sets.filter(this.detailsOnAllNodes(), (Predicate)Predicates.and((Predicate)((Predicate)Preconditions.checkNotNull(filter, (Object)"filter")), (Predicate)Predicates.not(NodePredicates.TERMINATED)));
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(Predicate<NodeMetadata> filter) {
        Iterable<? extends NodeMetadata> nodes = this.nodesMatchingFilterAndNotTerminated(filter);
        if (Iterables.size(nodes) == 0) {
            throw new NoSuchElementException("no nodes matched filter: " + filter);
        }
        return nodes;
    }

    public Set<ComputeMetadata> listNodes() {
        this.logger.trace(">> listing nodes", new Object[0]);
        LinkedHashSet set = Sets.newLinkedHashSet(this.listNodesStrategy.listNodes());
        this.logger.trace("<< list(%d)", new Object[]{set.size()});
        return set;
    }

    @Override
    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<ComputeMetadata> filter) {
        Preconditions.checkNotNull(filter, (Object)"filter");
        this.logger.trace(">> listing node details matching(%s)", new Object[]{filter});
        LinkedHashSet set = Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(filter));
        this.logger.trace("<< list(%d)", new Object[]{set.size()});
        return set;
    }

    @Override
    public Set<? extends Hardware> listHardwareProfiles() {
        return (Set)this.hardwareProfiles.get();
    }

    @Override
    public Set<? extends Image> listImages() {
        return (Set)this.images.get();
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    @Override
    public TemplateBuilder templateBuilder() {
        return (TemplateBuilder)this.templateBuilderProvider.get();
    }

    @Override
    public NodeMetadata getNodeMetadata(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return this.getNodeMetadataStrategy.getNode(id);
    }

    @Override
    public Image getImage(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return this.getImageStrategy.getImage(id);
    }

    @Override
    public void rebootNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> rebooting node(%s)", new Object[]{id});
        AtomicReference<NodeMetadata> node = new AtomicReference<NodeMetadata>(this.rebootNodeStrategy.rebootNode(id));
        boolean successful = this.nodeRunning.apply(node);
        this.logger.debug("<< rebooted node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public void rebootNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> rebooting nodes matching(%s)", new Object[]{filter});
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), (Function)new Function<NodeMetadata, Future<? extends Void>>(){

            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.rebootNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("rebootNodesMatching(" + filter + ")"));
        this.logger.debug("<< rebooted", new Object[0]);
    }

    @Override
    public void resumeNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> resuming node(%s)", new Object[]{id});
        AtomicReference<NodeMetadata> node = new AtomicReference<NodeMetadata>(this.resumeNodeStrategy.resumeNode(id));
        boolean successful = this.nodeRunning.apply(node);
        this.logger.debug("<< resumed node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public void resumeNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> resuming nodes matching(%s)", new Object[]{filter});
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), (Function)new Function<NodeMetadata, Future<? extends Void>>(){

            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.resumeNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("resumeNodesMatching(" + filter + ")"));
        this.logger.debug("<< resumed", new Object[0]);
    }

    @Override
    public void suspendNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> suspending node(%s)", new Object[]{id});
        AtomicReference<NodeMetadata> node = new AtomicReference<NodeMetadata>(this.suspendNodeStrategy.suspendNode(id));
        boolean successful = this.nodeSuspended.apply(node);
        this.logger.debug("<< suspended node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public void suspendNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> suspending nodes matching(%s)", new Object[]{filter});
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), (Function)new Function<NodeMetadata, Future<? extends Void>>(){

            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.suspendNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("suspendNodesMatching(" + filter + ")"));
        this.logger.debug("<< suspended", new Object[0]);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.exec((String)((String)Preconditions.checkNotNull((Object)runScript, (Object)"runScript"))));
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, runScript, RunScriptOptions.NONE);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.exec((String)((String)Preconditions.checkNotNull((Object)runScript, (Object)"runScript"))), options);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        Preconditions.checkNotNull(filter, (Object)"filter");
        Preconditions.checkNotNull((Object)runScript, (Object)"runScript");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        Map goodNodes = Maps.newLinkedHashMap();
        Map<NodeMetadata, Exception> badNodes = Maps.newLinkedHashMap();
        LinkedHashMap responses = Maps.newLinkedHashMap();
        Object exceptions = ImmutableMap.of();
        this.initAdminAccess.visit(runScript);
        Iterable<? extends RunScriptOnNode> scriptRunners = this.transformNodesIntoInitializedScriptRunners(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), runScript, options, badNodes);
        if (Iterables.size(scriptRunners) > 0) {
            for (RunScriptOnNode runScriptOnNode : scriptRunners) {
                responses.put(runScriptOnNode.getNode(), this.executor.submit(new RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap(runScriptOnNode, goodNodes, badNodes)));
            }
            try {
                exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("runScriptOnNodesMatching(" + filter + ")"));
            }
            catch (TimeoutException te) {
                throw Throwables.propagate((Throwable)te);
            }
        }
        Function<NodeMetadata, NodeMetadata> fn = this.persistNodeCredentials.ifAdminAccess(runScript);
        badNodes = Maps2.transformKeys((Map)badNodes, fn);
        goodNodes = Maps2.transformKeys((Map)goodNodes, fn);
        if (exceptions.size() > 0 || badNodes.size() > 0) {
            throw new RunScriptOnNodesException(runScript, options, goodNodes, (Map<?, Exception>)exceptions, (Map<? extends NodeMetadata, ? extends Throwable>)badNodes);
        }
        return goodNodes;
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript) {
        return this.runScriptOnNode(id, runScript, RunScriptOptions.NONE);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript, RunScriptOptions options) {
        return this.runScriptOnNode(id, Statements.exec((String)((String)Preconditions.checkNotNull((Object)runScript, (Object)"runScript"))), options);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript) {
        return this.runScriptOnNode(id, runScript, RunScriptOptions.NONE);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        NodeMetadata node = this.getNodeMetadata(id);
        if (node == null) {
            throw new NoSuchElementException(id);
        }
        if (node.getStatus() != NodeMetadata.Status.RUNNING) {
            throw new IllegalStateException("node " + id + " needs to be running before executing a script on it. current state: " + ComputeServiceUtils.formatStatus(node));
        }
        this.initAdminAccess.visit(runScript);
        node = this.updateNodeWithCredentialsIfPresent(node, options);
        ExecResponse response = this.runScriptOnNodeFactory.create(node, runScript, options).init().call();
        this.persistNodeCredentials.ifAdminAccess(runScript).apply((Object)node);
        return response;
    }

    @Override
    public ListenableFuture<ExecResponse> submitScriptOnNode(String id, final Statement runScript, RunScriptOptions options) {
        NodeMetadata node = this.getNodeMetadata(id);
        if (node == null) {
            throw new NoSuchElementException(id);
        }
        if (node.getStatus() != NodeMetadata.Status.RUNNING) {
            throw new IllegalStateException("node " + id + " needs to be running before executing a script on it. current state: " + ComputeServiceUtils.formatStatus(node));
        }
        this.initAdminAccess.visit(runScript);
        final NodeMetadata node1 = this.updateNodeWithCredentialsIfPresent(node, options);
        ListenableFuture<ExecResponse> response = this.runScriptOnNodeFactory.submit(node1, runScript, options);
        response.addListener(new Runnable(){

            @Override
            public void run() {
                BaseComputeService.this.persistNodeCredentials.ifAdminAccess(runScript).apply((Object)node1);
            }
        }, (Executor)this.executor);
        return response;
    }

    private Iterable<? extends RunScriptOnNode> transformNodesIntoInitializedScriptRunners(Iterable<? extends NodeMetadata> nodes, Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
        return Iterables.filter((Iterable)FutureIterables.transformParallel(nodes, (Function)new TransformNodesIntoInitializedScriptRunners(script, options, badNodes), (ExecutorService)this.executor, null, (Logger)this.logger, (String)"initialize script runners"), (Predicate)Predicates.notNull());
    }

    private Set<? extends NodeMetadata> detailsOnAllNodes() {
        return Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(NodePredicates.all()));
    }

    @Override
    public TemplateOptions templateOptions() {
        return (TemplateOptions)this.templateOptionsProvider.get();
    }

    protected NodeMetadata updateNodeWithCredentialsIfPresent(NodeMetadata node, RunScriptOptions options) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        LoginCredentials.Builder builder = LoginCredentials.builder((Credentials)node.getCredentials());
        if (options.getLoginUser() != null) {
            builder.user(options.getLoginUser());
        }
        if (options.hasLoginPasswordOption()) {
            if (options.hasLoginPassword()) {
                builder.password(options.getLoginPassword());
            } else {
                builder.noPassword();
            }
        }
        if (options.hasLoginPrivateKeyOption()) {
            if (options.hasLoginPrivateKey()) {
                builder.privateKey(options.getLoginPrivateKey());
            } else {
                builder.noPrivateKey();
            }
        }
        if (options.shouldAuthenticateSudo() != null) {
            builder.authenticateSudo(true);
        }
        return NodeMetadataBuilder.fromNodeMetadata(node).credentials(builder.build()).build();
    }

    @Override
    public Optional<ImageExtension> getImageExtension() {
        return this.imageExtension;
    }

    private final class TransformNodesIntoInitializedScriptRunners
    implements Function<NodeMetadata, Future<? extends RunScriptOnNode>> {
        private final Map<NodeMetadata, Exception> badNodes;
        private final Statement script;
        private final RunScriptOptions options;

        private TransformNodesIntoInitializedScriptRunners(Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
            this.badNodes = (Map)Preconditions.checkNotNull(badNodes, (Object)"badNodes");
            this.script = (Statement)Preconditions.checkNotNull((Object)script, (Object)"script");
            this.options = (RunScriptOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
        }

        public Future<RunScriptOnNode> apply(NodeMetadata node) {
            node = BaseComputeService.this.updateNodeWithCredentialsIfPresent(node, this.options);
            return BaseComputeService.this.executor.submit(BaseComputeService.this.initScriptRunnerFactory.create(node, this.script, this.options, this.badNodes));
        }
    }
}

