/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2AsyncClient;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Preconditions2;

@Singleton
public class AWSEC2ComputeService
extends EC2ComputeService {
    private final LoadingCache<RegionAndName, String> placementGroupMap;
    private final Predicate<PlacementGroup> placementGroupDeleted;
    private final AWSEC2Client ec2Client;
    private final AWSEC2AsyncClient aclient;
    private final boolean generateInstanceNames;

    @Inject
    protected AWSEC2ComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, AWSEC2Client ec2Client, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, @Named(value="PLACEMENT") LoadingCache<RegionAndName, String> placementGroupMap, @Named(value="DELETED") Predicate<PlacementGroup> placementGroupDeleted, @Named(value="jclouds.ec2.generate-instance-names") boolean generateInstanceNames, AWSEC2AsyncClient aclient, Optional<ImageExtension> imageExtension, GroupNamingConvention.Factory namingConvention) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, runScriptOnNodeFactory, initAdminAccess, persistNodeCredentials, timeouts, executor, (EC2Client)ec2Client, credentialsMap, securityGroupMap, imageExtension, namingConvention);
        this.ec2Client = ec2Client;
        this.placementGroupMap = placementGroupMap;
        this.placementGroupDeleted = placementGroupDeleted;
        this.generateInstanceNames = generateInstanceNames;
        this.aclient = (AWSEC2AsyncClient)Preconditions.checkNotNull((Object)aclient, (Object)"aclient");
    }

    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Set<? extends NodeMetadata> nodes = super.createNodesInGroup(group, count, template);
        if (this.templateWasASpotRequestWithUserMetadata(template)) {
            this.addTagsToNodesFromUserMetadataInTemplate(nodes, group, template);
            nodes = this.addUserMetadataFromTemplateOptionsToNodes(template, group, nodes);
        }
        return nodes;
    }

    protected void addTagsToNodesFromUserMetadataInTemplate(Set<? extends NodeMetadata> nodes, String group, Template template) {
        String region = AWSUtils.getRegionFromLocationOrNull((Location)template.getLocation());
        if (template.getOptions().getUserMetadata().size() > 0 || this.generateInstanceNames) {
            for (String id : Iterables.transform(nodes, (Function)new Function<NodeMetadata, String>(){

                public String apply(NodeMetadata arg0) {
                    return arg0.getProviderId();
                }
            })) {
                this.aclient.getTagServices().createTagsInRegion(region, (Iterable<String>)ImmutableSet.of((Object)id), this.metadataForId(id, group, template.getOptions().getUserMetadata()));
            }
        }
    }

    private Map<String, String> metadataForId(String id, String group, Map<String, String> metadata) {
        return this.generateInstanceNames && !metadata.containsKey("Name") ? ImmutableMap.builder().putAll(metadata).put((Object)"Name", (Object)id.replaceAll(".*-", group + "-")).build() : metadata;
    }

    protected boolean templateWasASpotRequestWithUserMetadata(Template template) {
        return template.getOptions().getUserMetadata().size() > 0 && ((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(template.getOptions())).getSpotPrice() != null;
    }

    protected Set<? extends NodeMetadata> addUserMetadataFromTemplateOptionsToNodes(final Template template, final String group, Set<? extends NodeMetadata> nodes) {
        nodes = ImmutableSet.copyOf((Iterable)Iterables.transform(nodes, (Function)new Function<NodeMetadata, NodeMetadata>(){

            public NodeMetadata apply(NodeMetadata arg0) {
                Map md = AWSEC2ComputeService.this.metadataForId(arg0.getProviderId(), group, template.getOptions().getUserMetadata());
                return NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)arg0).name((String)md.get("Name")).userMetadata(md).build();
            }
        }));
        return nodes;
    }

    @VisibleForTesting
    void deletePlacementGroup(String region, String group) {
        Preconditions2.checkNotEmpty((String)group, (String)"group");
        String placementGroup = String.format("jclouds#%s#%s", group, region);
        try {
            if (this.ec2Client.getPlacementGroupServices().describePlacementGroupsInRegion(region, placementGroup).size() > 0) {
                this.logger.debug(">> deleting placementGroup(%s)", new Object[]{placementGroup});
                try {
                    this.ec2Client.getPlacementGroupServices().deletePlacementGroupInRegion(region, placementGroup);
                    Preconditions.checkState((boolean)this.placementGroupDeleted.apply((Object)new PlacementGroup(region, placementGroup, "cluster", PlacementGroup.State.PENDING)), (Object)String.format("placementGroup region(%s) name(%s) failed to delete", region, placementGroup));
                    this.placementGroupMap.invalidate((Object)new RegionAndName(region, placementGroup));
                    this.logger.debug("<< deleted placementGroup(%s)", new Object[]{placementGroup});
                }
                catch (IllegalStateException e) {
                    this.logger.debug("<< inUse placementGroup(%s)", new Object[]{placementGroup});
                }
            }
        }
        catch (UnsupportedOperationException e) {
            this.logger.trace("<< placementGroups unsupported in region %s", new Object[]{region});
        }
    }

    protected void cleanUpIncidentalResources(String region, String group) {
        super.cleanUpIncidentalResources(region, group);
        this.deletePlacementGroup(region, group);
    }

    public EC2TemplateOptions templateOptions() {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.templateOptions());
    }
}

