/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DescribedFuture<T>
implements Future<T> {
    protected final Future<T> delegate;
    private final String description;
    private StackTraceElement[] submissionTrace;

    public DescribedFuture(Future<T> delegate, String description, StackTraceElement[] submissionTrace) {
        this.delegate = delegate;
        this.description = description;
        this.submissionTrace = submissionTrace;
    }

    @Override
    public boolean cancel(boolean arg0) {
        return this.delegate.cancel(arg0);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.delegate.get();
        }
        catch (ExecutionException e) {
            throw this.ensureCauseHasSubmissionTrace(e);
        }
        catch (InterruptedException e) {
            throw this.ensureCauseHasSubmissionTrace(e);
        }
    }

    @Override
    public T get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.delegate.get(arg0, arg1);
        }
        catch (ExecutionException e) {
            throw this.ensureCauseHasSubmissionTrace(e);
        }
        catch (InterruptedException e) {
            throw this.ensureCauseHasSubmissionTrace(e);
        }
        catch (TimeoutException e) {
            throw this.ensureCauseHasSubmissionTrace(e);
        }
    }

    private <ET extends Exception> ET ensureCauseHasSubmissionTrace(ET e) {
        if (this.submissionTrace == null) {
            return e;
        }
        if (e.getCause() == null) {
            ExecutionException ee = new ExecutionException("task submitted from the following trace", null);
            e.initCause(ee);
            return e;
        }
        Throwable cause = e.getCause();
        StackTraceElement[] causeTrace = cause.getStackTrace();
        boolean causeIncludesSubmissionTrace = this.submissionTrace.length >= causeTrace.length;
        for (int i = 0; causeIncludesSubmissionTrace && i < this.submissionTrace.length; ++i) {
            if (causeTrace[causeTrace.length - 1 - i].equals(this.submissionTrace[this.submissionTrace.length - 1 - i])) continue;
            causeIncludesSubmissionTrace = false;
        }
        if (!causeIncludesSubmissionTrace) {
            cause.setStackTrace(this.merge(causeTrace, this.submissionTrace));
        }
        return e;
    }

    private StackTraceElement[] merge(StackTraceElement[] t1, StackTraceElement[] t2) {
        StackTraceElement[] t12 = new StackTraceElement[t1.length + t2.length];
        System.arraycopy(t1, 0, t12, 0, t1.length);
        System.arraycopy(t2, 0, t12, t1.length, t2.length);
        return t12;
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.description;
    }
}

