/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.RetryAfterException;
import org.jclouds.rest.functions.PropagateIfRetryAfter;

@Beta
public final class HeaderToRetryAfterException
implements PropagateIfRetryAfter {
    private final Ticker ticker;
    private final DateCodec dateCodec;

    public static HeaderToRetryAfterException create(Ticker ticker, DateCodec dateCodec) {
        return new HeaderToRetryAfterException(ticker, dateCodec);
    }

    @Inject
    private HeaderToRetryAfterException(DateCodecFactory factory) {
        this(Ticker.systemTicker(), factory.rfc822());
    }

    private HeaderToRetryAfterException(Ticker ticker, DateCodec dateCodec) {
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
        this.dateCodec = (DateCodec)Preconditions.checkNotNull((Object)dateCodec, (Object)"dateCodec");
    }

    public Void apply(Throwable in) {
        Optional<RetryAfterException> retryException;
        if (!(in instanceof HttpResponseException)) {
            return null;
        }
        HttpResponse response = ((HttpResponseException)HttpResponseException.class.cast(in)).getResponse();
        if (response == null) {
            return null;
        }
        String retryAfter = response.getFirstHeaderOrNull("Retry-After");
        if (retryAfter != null && (retryException = this.tryCreateRetryAfterException(in, retryAfter)).isPresent()) {
            throw (RetryAfterException)retryException.get();
        }
        return null;
    }

    public Optional<RetryAfterException> tryCreateRetryAfterException(Throwable in, String retryAfter) {
        Preconditions.checkNotNull((Object)in, (Object)"throwable");
        Preconditions.checkNotNull((Object)retryAfter, (Object)"retryAfter");
        if (retryAfter.matches("^[0-9]+$")) {
            return Optional.of((Object)new RetryAfterException(in, Integer.parseInt(retryAfter)));
        }
        try {
            long retryTimeMillis = this.dateCodec.toDate(retryAfter).getTime();
            long currentTimeMillis = TimeUnit.NANOSECONDS.toMillis(this.ticker.read());
            return Optional.of((Object)new RetryAfterException(in, (int)TimeUnit.MILLISECONDS.toSeconds(retryTimeMillis - currentTimeMillis)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.absent();
        }
    }
}

