/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;
import org.jclouds.util.Multimaps2;

@Singleton
public class RedirectionRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Named(value="jclouds.max-redirects")
    protected int retryCountLimit = 5;
    @Resource
    protected Logger logger = Logger.NULL;
    protected final BackoffLimitedRetryHandler backoffHandler;

    @Inject
    protected RedirectionRetryHandler(BackoffLimitedRetryHandler backoffHandler) {
        this.backoffHandler = backoffHandler;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        HttpUtils.closeClientButKeepContentStream(response);
        String hostHeader = response.getFirstHeaderOrNull("Location");
        if (command.incrementRedirectCount() < this.retryCountLimit && hostHeader != null) {
            HttpRequest currentRequest;
            URI redirectionUrl = URI.create(hostHeader);
            if (redirectionUrl.equals((currentRequest = command.getCurrentRequest()).getEndpoint())) {
                return this.backoffHandler.shouldRetryRequest(command, response);
            }
            assert (redirectionUrl.getPath() != null) : "no path in redirect header from: " + response;
            if (!redirectionUrl.isAbsolute()) {
                redirectionUrl = Uris.uriBuilder(currentRequest.getEndpoint()).path(redirectionUrl.getPath()).query(redirectionUrl.getQuery()).build();
            }
            if (currentRequest.getFirstHeaderOrNull("Host") != null && redirectionUrl.getHost() != null) {
                String host = redirectionUrl.getHost();
                if (redirectionUrl.getPort() != -1) {
                    host = host + ":" + redirectionUrl.getPort();
                }
                Multimap<String, String> newHeaders = Multimaps2.replaceValue(currentRequest.getHeaders(), "Host", host);
                command.setCurrentRequest(((HttpRequest.Builder)((HttpRequest.Builder)currentRequest.toBuilder().headers(newHeaders)).endpoint(redirectionUrl)).build());
            } else {
                command.setCurrentRequest(((HttpRequest.Builder)((HttpRequest.Builder)currentRequest.toBuilder()).endpoint(redirectionUrl)).build());
            }
            return true;
        }
        return false;
    }
}

