/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.predicates;

import com.google.common.base.Predicate;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;
import org.jclouds.util.Throwables2;

public class RetryablePredicate<T>
implements Predicate<T> {
    public static final long DEFAULT_PERIOD = 50L;
    public static final long DEFAULT_MAX_PERIOD = 1000L;
    private final long maxWait;
    private final long period;
    private final long maxPeriod;
    private final Predicate<T> predicate;
    @Resource
    protected Logger logger = Logger.NULL;

    public RetryablePredicate(Predicate<T> predicate, long maxWait, long period, long maxPeriod, TimeUnit unit) {
        this.predicate = predicate;
        this.maxWait = unit.toMillis(maxWait);
        this.period = unit.toMillis(period);
        this.maxPeriod = unit.toMillis(maxPeriod);
    }

    public RetryablePredicate(Predicate<T> predicate, long maxWait, long period, TimeUnit unit) {
        this(predicate, maxWait, period, period * 10L, unit);
    }

    public RetryablePredicate(Predicate<T> predicate, long maxWait, long period, long maxPeriod) {
        this(predicate, maxWait, period, maxPeriod, TimeUnit.MILLISECONDS);
    }

    public RetryablePredicate(Predicate<T> predicate, long maxWait) {
        this(predicate, maxWait, 50L, 1000L, TimeUnit.MILLISECONDS);
    }

    public boolean apply(T input) {
        try {
            long i = 1L;
            Date end = new Date(System.currentTimeMillis() + this.maxWait);
            while (this.before(end)) {
                if (this.predicate.apply(input)) {
                    return true;
                }
                if (this.atOrAfter(end)) {
                    return false;
                }
                Thread.sleep(this.nextMaxInterval(i++, end));
            }
        }
        catch (InterruptedException e) {
            this.logger.warn(e, "predicate %s on %s interrupted, returning false", input, this.predicate);
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            if (Throwables2.getFirstThrowableOfType(e, ExecutionException.class) != null) {
                this.logger.warn(e, "predicate %s on %s errored [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(e, IllegalStateException.class) != null) {
                this.logger.warn(e, "predicate %s on %s illegal state [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(e, CancellationException.class) != null) {
                this.logger.warn(e, "predicate %s on %s cancelled [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(e, TimeoutException.class) != null) {
                this.logger.warn(e, "predicate %s on %s timed out [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            throw e;
        }
        return false;
    }

    protected long nextMaxInterval(long attempt, Date end) {
        long interval = (long)((double)this.period * Math.pow(1.5, attempt - 1L));
        interval = interval > this.maxPeriod ? this.maxPeriod : interval;
        long max = end.getTime() - System.currentTimeMillis();
        return interval > max ? max : interval;
    }

    protected boolean before(Date end) {
        return new Date().compareTo(end) <= 1;
    }

    protected boolean atOrAfter(Date end) {
        return new Date().compareTo(end) >= 0;
    }
}

