/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers;

import com.google.common.base.Preconditions;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;
import org.jclouds.rest.AnonymousRestApiMetadata;

public class AnonymousProviderMetadata
extends BaseProviderMetadata {
    private static final long serialVersionUID = 3038298137724260273L;

    public static ProviderMetadata forClientMappedToAsyncClientOnEndpoint(Class<?> client, Class<?> asyncClient, String endpoint) {
        return AnonymousProviderMetadata.forApiWithEndpoint(AnonymousRestApiMetadata.forClientMappedToAsyncClient(client, asyncClient), endpoint);
    }

    public static ProviderMetadata forApiWithEndpoint(ApiMetadata md, String endpoint) {
        Preconditions.checkNotNull((Object)md, (Object)"api");
        Preconditions.checkNotNull((Object)endpoint, (String)"endpoint (%s)", (Object[])new Object[]{md.getEndpointName()});
        return new AnonymousProviderMetadata(md, endpoint);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)new Builder(this.getApiMetadata(), this.getEndpoint()).fromProviderMetadata(this);
    }

    public AnonymousProviderMetadata(ApiMetadata apiMetadata, String endpoint) {
        super(new Builder(apiMetadata, endpoint));
    }

    public AnonymousProviderMetadata(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        public Builder(ApiMetadata apiMetadata, String endpoint) {
            this.id(((ApiMetadata)Preconditions.checkNotNull((Object)apiMetadata, (Object)"apiMetadata")).getId()).name(apiMetadata.getName()).apiMetadata(apiMetadata).endpoint(endpoint);
        }

        @Override
        public AnonymousProviderMetadata build() {
            return new AnonymousProviderMetadata(this);
        }
    }
}

