/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import com.google.common.net.InternetDomainName;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.rest.Binder;

@Singleton
public class BindAsHostPrefix
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"hostprefix");
        Preconditions.checkArgument((boolean)InternetDomainName.isValid((String)request.getEndpoint().getHost()), (Object)("this is only valid for hostnames: " + request));
        InternetDomainName name = InternetDomainName.from((String)request.getEndpoint().getHost()).child(payload.toString());
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(Uris.uriBuilder(request.getEndpoint()).host(name.name()).build())).build();
    }
}

