/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.file.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.overthere.Host;

@Metadata(virtual=true, description="Abstract deployed that can target any DeployableArtifact to a Host.")
public class DeployedArtifactOnHost<D extends DeployableArtifact>
extends BaseDeployedArtifact<D, Host> {
    @Property(description="Path to which artifact must be copied to on the host.")
    private String targetPath;
    @Property(required=false, defaultValue="true", description="Is the targetPath shared by others on the host. When true, the targetPath is not deleted during undeployment; only the artifacts copied to it.")
    private boolean targetPathShared;
    @Property(required=false, defaultValue="false", description="Create the targetPath on the host if it does not exist.")
    private boolean createTargetPath;
    @Property(required=false, description="Name of the artifact on the host.")
    private String targetFileName;
    @Property(defaultValue="false", required=false, hidden=true, description="If set to true, files are directly copied to the target directory without first being uploaded to the staging or temporary directory (like versions of XL Deploy prior to 4.0.0)")
    private boolean copyDirectlyToTargetPath;
    @Property(defaultValue="false", required=false, hidden=true, description="The sub directories on the target machine are not deleted if files other than that copied by XL Deploy are present. ")
    private boolean targetPathSharedSubDirectories;

    private CopiedArtifact<D> createDelegate() {
        CopiedArtifact delegate = new CopiedArtifact(this.getId());
        Descriptor thisDescriptor = this.getType().getDescriptor();
        delegate.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> thisDescriptor.getPropertyDescriptor(pd.getName()) != null).forEach(pd -> pd.set((ConfigurationItem)delegate, thisDescriptor.getPropertyDescriptor(pd.getName()).get((ConfigurationItem)this)));
        delegate.setPlaceholders(this.getPlaceholders());
        delegate.setFile(this.getFile());
        Container container = new Container(((Host)this.getContainer()).getId());
        container.setHost((Host)this.getContainer());
        delegate.setContainer((com.xebialabs.deployit.plugin.api.udm.Container)container);
        delegate.setDeployable(this.getDeployable());
        delegate.setCreateOrder(60);
        delegate.setDestroyOrder(40);
        delegate.setCreateTargetDirectory(this.isCreateTargetPath());
        delegate.setTargetFile(this.getTargetFileName());
        delegate.setTargetDirectory(this.getTargetPath());
        delegate.setTargetDirectoryShared(this.isTargetPathShared());
        delegate.setUseDescriptionGeneratedByStep(true);
        delegate.setCopyDirectlyToTargetPath(this.copyDirectlyToTargetPath);
        delegate.setTargetPathSharedSubDirectories(this.targetPathSharedSubDirectories);
        return delegate;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        CopiedArtifact<D> delegate = this.createDelegate();
        delegate.executeCreate(ctx, delta);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        DeployedArtifactOnHost previous = (DeployedArtifactOnHost)delta.getPrevious();
        previous.executeDestroy(ctx, delta);
        this.executeCreate(ctx, delta);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        CopiedArtifact<D> delegate = this.createDelegate();
        delegate.executeDestroy(ctx, delta);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public boolean isTargetPathShared() {
        return this.targetPathShared;
    }

    public void setTargetPathShared(boolean targetPathShared) {
        this.targetPathShared = targetPathShared;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isCopyDirectlyToTargetPath() {
        return this.copyDirectlyToTargetPath;
    }

    public void setCopyDirectlyToTargetPath(boolean copyDirectlyToTargetPath) {
        this.copyDirectlyToTargetPath = copyDirectlyToTargetPath;
    }

    public boolean isTargetPathSharedSubDirectories() {
        return this.targetPathSharedSubDirectories;
    }

    public void setTargetPathSharedSubDirectories(boolean targetPathSharedSubDirectories) {
        this.targetPathSharedSubDirectories = targetPathSharedSubDirectories;
    }
}

