/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.generic.freemarker.ArtifactUploader;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.OSScriptSanitizerWrapper;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseStep
extends CalculatedStep
implements SatelliteAware {
    public static final String FREEMARKER_FILE_EXT = ".ftl";
    protected HostContainer container;
    private String remoteWorkingDirPath;
    private boolean retainRemoteWorkingDirOnCompletion;
    private transient OverthereConnection localConn;
    protected transient OverthereConnection remoteConn;
    protected transient ExecutionContext ctx;
    private transient OverthereFile remoteWorkingDir;
    private transient ArtifactUploader artifactUploader;

    protected BaseStep() {
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(BaseStep.class);
    }

    protected BaseStep(HostContainer container) {
        this(null, container);
    }

    protected BaseStep(String description, HostContainer container) {
        this(null, description, container);
    }

    protected BaseStep(Integer order, String description, HostContainer container) {
        super(order, description);
        this.container = container;
    }

    public StepExitCode handleExecute(ExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            StepExitCode stepExitCode = this.doExecute();
            return stepExitCode;
        }
        finally {
            this.disconnect();
        }
    }

    protected abstract StepExitCode doExecute() throws Exception;

    protected ExecutionContext getCtx() {
        return this.ctx;
    }

    public HostContainer getContainer() {
        return this.container;
    }

    public OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) ? this.getRemoteConnection().getTempFile("generic_plugin", ".tmp") : this.getRemoteConnection().getFile(this.getRemoteWorkingDirPath());
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    public OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = LocalConnection.getLocalConnection();
        }
        return this.localConn;
    }

    public OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.getContainer().getHost().getConnection();
        }
        return this.remoteConn;
    }

    protected void disconnect() {
        Closeables.closeQuietly((Closeable)this.localConn);
        if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) && !this.isRetainRemoteWorkingDirOnCompletion()) {
            this.getRemoteWorkingDirectory().deleteRecursively();
        }
        Closeables.closeQuietly((Closeable)this.remoteConn);
        this.remoteWorkingDir = null;
        this.localConn = null;
        this.remoteConn = null;
        this.artifactUploader = null;
    }

    public ArtifactUploader getArtifactUploader() {
        if (this.artifactUploader == null) {
            this.artifactUploader = this.createArtifactUploader();
        }
        return this.artifactUploader;
    }

    public String getRemoteWorkingDirPath() {
        return this.remoteWorkingDirPath;
    }

    public void setRemoteWorkingDirPath(String remoteWorkingDirPath) {
        this.remoteWorkingDirPath = remoteWorkingDirPath;
    }

    public boolean isRetainRemoteWorkingDirOnCompletion() {
        return this.retainRemoteWorkingDirOnCompletion;
    }

    public void setRetainRemoteWorkingDirOnCompletion(boolean deleteWorkingDirOnCompletion) {
        this.retainRemoteWorkingDirOnCompletion = deleteWorkingDirOnCompletion;
    }

    protected OverthereFile uploadToWorkingDirectory(String content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)target);
        return target;
    }

    protected OverthereFile uploadToWorkingDirectory(File content, String fileName) {
        String fileType = content.isDirectory() ? "directory" : "file";
        this.getCtx().logOutput("Uploading " + fileType + " " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        LocalFile.valueOf((File)content).copyTo(target);
        return target;
    }

    protected OverthereFile uploadToWorkingDirectory(URL content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        try (OutputStream out = target.getOutputStream();){
            Resources.copy((URL)content, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        return target;
    }

    public boolean hostFileExists(String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        return file.exists();
    }

    public String getHostLineSeparator() {
        return this.getContainer().getHost().getOs().getLineSeparator();
    }

    public String getHostFileSeparator() {
        return this.getContainer().getHost().getOs().getFileSeparator();
    }

    public String readHostFile(String remoteFile) {
        String string;
        block8: {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
            OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
            Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object)remoteFile, (Object)this.getContainer().getHost());
            InputStream in = file.getInputStream();
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                string = new String(bytes);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Failed to read file " + remoteFile, (Throwable)e);
                }
            }
            in.close();
        }
        return string;
    }

    public String[] readHostFileLines(String remoteFile) {
        String data = this.readHostFile(remoteFile);
        Iterable iterable = Splitter.on((String)this.getHostLineSeparator()).split((CharSequence)data);
        return (String[])Iterables.toArray((Iterable)iterable, String.class);
    }

    public void createOrReplaceHostFile(String content, String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        Preconditions.checkNotNull((Object)content);
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        if (file.exists()) {
            this.getLogger().debug("File " + remoteFile + " already exists. Will delete before attempting to write.");
            file.delete();
        }
        if (!file.getParentFile().exists()) {
            this.getLogger().debug("Parent directory does not exist. Will create it.");
            file.getParentFile().mkdirs();
        }
        try (ByteArrayInputStream from = new ByteArrayInputStream(content.getBytes());
             OutputStream to = file.getOutputStream();){
            ByteStreams.copy((InputStream)from, (OutputStream)to);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to write to " + remoteFile, (Throwable)e);
        }
    }

    public NodeModel readHostXmlFileAsModel(String remoteXmlFile) {
        NodeModel nodeModel;
        block9: {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteXmlFile));
            OverthereFile file = this.getRemoteConnection().getFile(remoteXmlFile);
            Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object)remoteXmlFile, (Object)this.getContainer().getHost());
            InputStream remoteXmlStream = file.getInputStream();
            try {
                nodeModel = NodeModel.parse((InputSource)new InputSource(remoteXmlStream), (boolean)false, (boolean)true);
                if (remoteXmlStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (remoteXmlStream != null) {
                        try {
                            remoteXmlStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException exc) {
                    throw new RuntimeException("Cannot read xml file " + remoteXmlFile, exc);
                }
                catch (IOException exc) {
                    throw new RuntimeIOException("Cannot read xml file " + remoteXmlFile, (Throwable)exc);
                }
            }
            remoteXmlStream.close();
        }
        return nodeModel;
    }

    public String evaluateTemplate(String templatePath, Map<String, Object> vars, boolean maskPasswords) {
        return this.evaluateTemplate(templatePath, vars, maskPasswords, this.getArtifactUploader());
    }

    public String evaluateTemplate(String templatePath, Map<String, Object> vars, boolean maskPasswords, ArtifactUploader artifactUploader) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            Map<String, Object> varsWithStatics = this.enrichedTemplateVariables(vars);
            template.createProcessingEnvironment(OSScriptSanitizerWrapper.addScriptSanitizers(templatePath, varsWithStatics), (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper(artifactUploader, maskPasswords)).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            this.getLogger().error("Exception Occured while evaluating the Template", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    protected ArtifactUploader createArtifactUploader() {
        return new ArtifactUploader(){

            @Override
            public String upload(Artifact file) {
                throw new UnsupportedOperationException("Artifact upload not supported in this step");
            }
        };
    }

    protected void evaluateTemplate(OverthereFile renderTo, String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try (OutputStream out = renderTo.getOutputStream();){
            Map<String, Object> variables = this.enrichedTemplateVariables(vars);
            Template template = cfg.getTemplate(templatePath);
            template.process(OSScriptSanitizerWrapper.addScriptSanitizers(templatePath, variables), (Writer)new OutputStreamWriter(out));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> enrichedTemplateVariables(Map<String, Object> vars) {
        HashMap variables = Maps.newHashMap(vars);
        variables.put("step", this);
        variables.put("context", this.getCtx());
        variables.put("statics", BeansWrapper.getDefaultInstance().getStaticModels());
        return variables;
    }

    public String resolveOsSpecificTemplate(String template) {
        if (this.classpathResourceExists(template + FREEMARKER_FILE_EXT)) {
            return template + FREEMARKER_FILE_EXT;
        }
        Object osSpecificTemplate = template;
        String scriptExt = BaseStep.substringAfterLast((String)osSpecificTemplate, '.');
        if (scriptExt == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificTemplate = (String)osSpecificTemplate + os.getScriptExtension();
        }
        if (!this.classpathResourceExists((String)osSpecificTemplate)) {
            String osSpecificScriptTemplate = (String)osSpecificTemplate + FREEMARKER_FILE_EXT;
            if (!this.classpathResourceExists(osSpecificScriptTemplate)) {
                throw new IllegalArgumentException("Resource " + (String)osSpecificTemplate + " not found in classpath");
            }
            osSpecificTemplate = osSpecificScriptTemplate;
        }
        return osSpecificTemplate;
    }

    public boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    public Satellite getSatellite() {
        return this.container.getHost().getSatellite();
    }

    public static String substringAfterLast(String str, char sub, String defaultValue) {
        String s = BaseStep.substringAfterLast(str, sub);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public static String substringAfterLast(String str, char sub) {
        int pos = str.lastIndexOf(sub);
        if (pos == -1) {
            return null;
        }
        return str.substring(pos + 1);
    }
}

