/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiTemplateModel
extends BeanModel {
    private static final String FILE_ATTRIBUTE = "file";
    private Descriptor descriptor;
    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper) {
        super((Object)ci, (BeansWrapper)wrapper);
        this.ci = ci;
        this.wrapper = wrapper;
        this.descriptor = DescriptorRegistry.getDescriptor((Type)ci.getType());
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals(FILE_ATTRIBUTE) && this.ci instanceof DeployableArtifact) {
            return this.handleFile();
        }
        PropertyDescriptor pd = this.descriptor.getPropertyDescriptor(key);
        if (pd == null) {
            return super.get(key);
        }
        return this.wrapper.wrap(this.extractValueFromCi(pd));
    }

    private Object extractValueFromCi(PropertyDescriptor pd) {
        if (pd.getKind() == PropertyKind.STRING && this.ci instanceof AbstractDeployed) {
            return ConfigurationHolder.resolveExpression((String)pd.get(this.ci), ((AbstractDeployed)this.ci).getDeployedAsFreeMarkerContext());
        }
        return pd.get(this.ci);
    }

    private TemplateModel handleFile() throws TemplateModelException {
        DeployableArtifact artifact = (DeployableArtifact)this.ci;
        Object o = artifact.getFile();
        if (this.wrapper.getUploader() != null) {
            o = this.wrapper.getUploader().upload(artifact.getFile());
        }
        return this.wrapper.wrap(o);
    }

    public boolean isEmpty() {
        return false;
    }
}

