package com.xebialabs.deployit.plugin.generic.ci;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder.resolveExpression;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A container that is nested with another container")
public class NestedContainer extends BaseContainer implements GenericContainer {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("container", (Object) this);

    @Property(required = false, description = "Environment variables for container", label="Environment Variables")
    private Map<String, String> envVars = newHashMap();

    public Map<String, String> getEnvVars() {
        return resolveExpression(envVars, freeMarkerContext);
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    @SuppressWarnings("rawtypes")
    public List<Step> controlTaskDispatch(String name) {
        String scriptPropertyName = name + "Script";
        PropertyDescriptor propertyDescriptor = DescriptorRegistry.getDescriptor(getType()).getPropertyDescriptor(scriptPropertyName);
        checkArgument(propertyDescriptor != null, "Control task script property %s not defined for CI type %s", scriptPropertyName, getType());
        String scriptName = resolveExpression((String) propertyDescriptor.get(this), freeMarkerContext);

        return Collections.<Step>singletonList(new ScriptExecutionStep(1, scriptName, this,
                freeMarkerContext, "Executing " + name));
    }


    public Container getRootContainer() {
        GenericContainer parentContainer = getParentContainer();
        if (parentContainer instanceof Container) {
            return (Container) parentContainer;
        } else if (parentContainer instanceof NestedContainer) {
            return ((NestedContainer) parentContainer).getRootContainer();
        } else {
            throw new IllegalStateException("The root container for a nested container not found. NestedContains should be rooted to a generic Container.");
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T extends GenericContainer> T getParentContainer() {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (pd.isAsContainment()) {
                return (T) pd.get(this);
            }
        }
        throw new IllegalStateException("This nested container " + getType() + " does not have an asContainment relationship to another generic container.");
    }

    @Override
    public Host getHost() {
        return getParentContainer().getHost();
    }
}
