package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiAwareObjectWrapper extends DefaultObjectWrapper {


    private FileUploader uploader;

    public CiAwareObjectWrapper() {
    }

    public CiAwareObjectWrapper(FileUploader uploader) {
        this.uploader = uploader;
    }

    @Override
    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj != null && obj instanceof ConfigurationItem) {
            return new CiTemplateModel((ConfigurationItem) obj, this);
        }
        return super.wrap(obj);
    }

    FileUploader getUploader() {
        return uploader;
    }
}
