package com.xebialabs.deployit.plugin.generic.freemarker;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Splitter;

import com.xebialabs.deployit.plugin.freemarker.Resolver;
import com.xebialabs.deployit.plugin.freemarker.ResolverForJava;

import freemarker.template.Configuration;

public class ConfigurationHolder {

    public static final Splitter RESOLVED_STRING_COLLECTION_SPLITTER = Splitter.onPattern("(?<!\\\\),").omitEmptyStrings().trimResults();

    public static Configuration getConfiguration() {
        return com.xebialabs.deployit.plugin.freemarker.ConfigurationHolder.configuration();
    }

    public static List<String> resolveExpression(List<String> expressions, final Object context) {
        return ResolverForJava.resolveJavaListExpressions(expressions, context);
    }
    
    public static Set<String> resolveExpression(Set<String> expressions, final Object context) {
        return ResolverForJava.resolveJavaSetExpressions(expressions, context);
    }

    public static Map<String, String> resolveExpression(Map<String, String> expressions, Map<String, Object> context) {
        return ResolverForJava.resolveJavaMapExpressions(expressions, context);
    }

    public static String resolveExpression(String expression, Object context) {
        return Resolver.resolveExpression(expression, context);
    }
}
