/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.freemarker.BaseCiTemplateModel;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiTemplateModel
extends BeanModel {
    private final BaseCiTemplateModel delegateModel;
    private static final String FILE_ATTRIBUTE = "file";
    public static final String MASKED_PASSWORD = "********";
    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper) {
        this(ci, wrapper, false);
    }

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper, boolean maskPasswords) {
        super((Object)ci, (BeansWrapper)wrapper);
        this.ci = ci;
        this.wrapper = wrapper;
        this.delegateModel = new BaseCiTemplateModel(ci, wrapper.getWrapper(), maskPasswords);
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals(FILE_ATTRIBUTE)) {
            if (this.ci instanceof SourceArtifact) {
                return this.handleSourceArtifact();
            }
            if (this.ci instanceof DerivedArtifact) {
                return this.handleDerivedArtifact();
            }
        }
        return this.delegateModel.get(key);
    }

    private TemplateModel handleSourceArtifact() throws TemplateModelException {
        return this.uploadArtifactIfUploaderPresent((Artifact)((SourceArtifact)this.ci));
    }

    private TemplateModel handleDerivedArtifact() throws TemplateModelException {
        return this.uploadArtifactIfUploaderPresent((Artifact)((DerivedArtifact)this.ci));
    }

    private TemplateModel uploadArtifactIfUploaderPresent(Artifact artifact) throws TemplateModelException {
        String path = artifact.getFile().getPath();
        if (this.wrapper.getUploader() != null) {
            path = this.wrapper.getUploader().upload(artifact);
        }
        return this.wrapper.wrap(path);
    }

    public boolean isEmpty() {
        return this.delegateModel.isEmpty();
    }
}

