/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCopyStep
extends BaseDeploymentStep
implements StageableStep {
    public static final String COPYSTRATEGY_PROPERTY = "copyStrategy";
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private Artifact sourceArtifact;
    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private boolean preserveExistingFiles;
    private StagedFile stagedSourceArtifact;

    public ArtifactCopyStep(int order, OverthereFile sourceFile, HostContainer container, String targetPath) {
        super(order, container);
        this.sourceFile = sourceFile;
        this.targetPath = targetPath;
        Preconditions.checkNotNull((Object)targetPath);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(ArtifactCopyStep.class);
    }

    public void requestStaging(StagingContext ctx) {
        if (this.sourceArtifact != null) {
            this.getLogger().debug("[{}] is requesting staging of [{}]", (Object)this, (Object)this.sourceArtifact);
            this.stagedSourceArtifact = ctx.stageArtifact(this.sourceArtifact, (StagingTarget)this.container.getHost());
        } else {
            this.getLogger().debug("[{}] is not requesting artifact staging.", (Object)this);
        }
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        Map metadata = this.getCtx().getTask().getMetadata();
        try {
            if (this.stagedSourceArtifact != null) {
                this.setRemoteCopyOptions();
                return this.doCopy(this.stagedSourceArtifact.get(this.getRemoteConnection(), this.getCtx()));
            }
            return this.doCopy(this.resolveSourceFile());
        }
        catch (Exception e) {
            if (Boolean.parseBoolean((String)metadata.get("enableCopyArtifactRetry"))) {
                return StepExitCode.RETRY;
            }
            return StepExitCode.FAIL;
        }
    }

    private void setRemoteCopyOptions() {
        ConnectionOptions connOptions = this.getRemoteConnection().getOptions();
        Host host = this.container.getHost();
        if (connOptions.getOptional("ARTIFACTFILE_COPYSTRATEGY") != null || !host.hasProperty(COPYSTRATEGY_PROPERTY)) {
            return;
        }
        CopyStrategyName strategy = (CopyStrategyName)host.getProperty(COPYSTRATEGY_PROPERTY);
        this.getLogger().debug("Setting artifact file copy strategy to {} for host {}", (Object)strategy, (Object)host.getId());
        connOptions.set("ARTIFACTFILE_COPYSTRATEGY", (Object)strategy);
    }

    private StepExitCode doCopy(OverthereFile sourceFile) {
        OverthereFile remoteFile;
        Preconditions.checkNotNull((Object)this.targetFileName);
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetPath);
        if (!remoteDir.exists()) {
            if (this.createTargetPath) {
                this.getCtx().logOutput("Creating path " + this.targetPath + " on host " + this.getContainer().getHost());
                remoteDir.mkdirs();
            } else if (sourceFile.isFile()) {
                this.getCtx().logError("Path " + this.targetPath + " on host " + this.getContainer().getHost() + " does not exist.");
                return StepExitCode.FAIL;
            }
        }
        if (sourceFile.isDirectory()) {
            remoteFile = remoteDir;
        } else {
            remoteFile = remoteDir.getFile(this.getTargetFileName());
            if (remoteFile.exists()) {
                this.getCtx().logOutput(remoteFile.getPath() + " already exists on host " + this.getContainer().getHost() + ". Will replace.");
                remoteFile.delete();
            }
        }
        this.getCtx().logOutput("Copying " + sourceFile.getPath() + " to " + remoteFile.getPath() + " on host " + this.getContainer().getHost());
        sourceFile.copyTo(remoteFile);
        return StepExitCode.SUCCESS;
    }

    protected OverthereFile resolveSourceFile() {
        Preconditions.checkNotNull((Object)this.sourceFile);
        return this.sourceFile;
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            return "Copy " + this.getSourceFileDescription() + " to " + this.getContainer().getHost();
        }
        return description;
    }

    public String getSourceFileDescription() {
        return this.sourceFileDescription;
    }

    public void setSourceFileDescription(String sourceFileDescription) {
        this.sourceFileDescription = sourceFileDescription;
    }

    public Artifact getSourceArtifact() {
        return this.sourceArtifact;
    }

    public void setSourceArtifact(Artifact sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isPreserveExistingFiles() {
        return this.preserveExistingFiles;
    }

    @Deprecated
    public void setPreserveExistingFiles(boolean preserveExistingFiles) {
        Deprecations.deprecated((String)"**Deprecated** Setting property 'preserveExistingFiles' on ArtifactCopyStep is deprecated and will be ignored.", (Object[])new Object[0]);
        this.preserveExistingFiles = preserveExistingFiles;
    }
}

