#Map of properties to be replaced as,in inspect script.  
propsToBeReplacedMap = {'contextRoot':'context-root', 'availabilityEnabled':'availability-enabled', 'javaWebStartEnabled': 'java-web-start-enabled'}

def buildDeployCommand(deployed, artifactPath, command):

    oo = dict({'target': 'domain', 'name': deployed.name}.items() + exposedPropertiesMap(deployed).items())

    pp = exposedPropertiesMap(deployed, category = "Additional Properties", d2g = propsToBeReplacedMap)

    return Create(command, oo, pp, artifactPath).build()

def deployApplication(deployed, command):

    def buildName(name, type):
        ext = (".%s" % type)
        return name if name.endswith(ext) else name + ext

    def uploadFile(file, targetName):
        return step.uploadToWorkingDirectory(file, targetName)

    appName = buildName(deployed.name, deployed.getProperty("extension"))
    uploadedArtifact = uploadFile(deployed.file, appName)
    logOutput("Installing as %s" % (appName))
    cmd = buildDeployCommand(deployed, uploadedArtifact.path, command)
    executeCmd(cmd)
    logOutput("Done.")
