if (!(Test-Path $deployed.physicalPath)) {
	Write-Output ("Creating empty website physical path " + $deployed.physicalPath)
	New-Item $deployed.physicalPath -type directory -force | Out-Null
}

Write-Output ("Creating website " + $deployed.name)
$newWebsite = New-Website -Name $deployed.name -Port $deployed.port -PhysicalPath $deployed.physicalPath
if($deployed.applicationPoolName) {
	$newWebsite | Set-ItemProperty -name applicationPool -value $deployed.applicationPoolName
}
