$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

if (!(Test-Path $deployed.physicalPath)) {
    Write-Output "Creating empty website physical path [$($deployed.physicalPath)]"
    if(!(New-Item $deployed.physicalPath -Type Directory -Force)) {
        Write-Error "Cannot create directory [$($deployed.physicalPath)]"
        Exit 1
    }
}

Write-Output "Creating website [$websiteName]"
$newWebsite = New-Website -Name $websiteName -Port $deployed.port -PhysicalPath $deployed.physicalPath
if($deployed.applicationPoolName) {
    $newWebsite | Set-ItemProperty -name applicationPool -value $deployed.applicationPoolName
}
