# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Start application pool, if it exists.
if (Test-Path "IIS:\AppPools\$applicationPoolName") {
    Write-Output "Starting application pool [$applicationPoolName]."
    Start-WebAppPool -Name $applicationPoolName | Out-Null
} else {
    Write-Output "Application pool [$applicationPoolName] does not exist and will not be started."
}
