Function convertIdentityTypeToServiceAccount($identityType) {
    if ($identityType -eq 0) {
        return "LocalSystem"
    } elseif ($identityType -eq 1) {
        return "LocalService"
    } elseif ($identityType -eq 2) {
        return "NetworkService"
    } elseif ($identityType -eq 3) {
        return "SpecificUser"
    } else {
        throw "Unknown IdentityType $identityType"
    }
}

$appPools = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class "IIsApplicationPoolSetting"
if($appPools) {
    foreach ($ap in $appPools) {
        $id = $container.id + "/" + $ap.name.substring(15)
        discovered $id $prototype.type
        $serviceAccount = convertIdentityTypeToServiceAccount  $ap.AppPoolIdentityType
        inspectedProperty $id "serviceAccount" $serviceAccount
        if ($serviceAccount -eq "SpecificUser") {
            inspectedProperty $id "username" $ap.WAMUsername
            inspectedProperty $id "password" $ap.WAMUserPass
        }
        inspectedItem $id
    }
}
