Function getWebsite($websiteName) {
    Return Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class "IIsWebServerSetting" -Filter "ServerComment = '$websiteName'"
}

Function getVirtualDirectory($website, $virtualDirectoryPath) {
    $virtualDirectory = New-Object System.DirectoryServices.DirectoryEntry("IIS://localhost/" + $website.Name + "/Root/$virtualDirectoryPath")
    if($virtualDirectory.Path) {
        Return $virtualDirectory
    } else {
        Return $null
    }
}

Function getDotNetVersions($installationPath) {
    if (!(Test-Path $installationPath)) {
       Throw "Path [$installationPath] does not exist. Please enter a correct path for the .NET Framework installation directory"
    }
    [string[]] $versions = Get-ChildItem $installationPath | ?{ $_.PSIsContainer } | Select -ExpandProperty Name
    Return $versions
}

Function getBestMatchForDotNetVersion($installationPath, $partialVersion) {
    $partialVersion = $partialVersion.toLower()
    $versions = getDotNetVersions $installationPath
    foreach ($version in $versions) {
        if ($version.toLower().startsWith($partialVersion.toLower())) {
            Return $version
        }
    }

    Throw "Failed to find a .NET version matching '$partialVersion'. Available versions are [$($versions -join ',')]"
}

Function updateDotNetVersionForVirtualDirectory($vdPath, $dotNetInstallationPath, $version) {
    $version = getBestMatchForDotNetVersion $dotNetInstallationPath $version
    & $dotNetInstallationPath\$version\aspnet_regiis.exe -sn $vdPath
    if(!$?) {
        Exit 1
    }
}

Function getDotNetVersionForVirtualDirectories($installationPath) {
    $version = (getDotNetVersions $installationPath)[0]
    Write-Host "Using .NET Version $version to list virtual directories and their .NET version"
    [string[]]$pathsAndVersions = & $installationPath\$version\aspnet_regiis.exe -lk
    $map = @{}
    foreach($pathAndVersion in $pathsAndVersions) {
        $splitPathAndVersion = $pathAndVersion.split()
        $vdPath = $splitPathAndVersion[0].trim().toLower()
        $vdDotNetVersion = $splitPathAndVersion[1].trim().toLower()
        $vdDotNetVersion = $vdDotNetVersion.substring(0,$vdDotNetVersion.lastIndexOf("."))
        $map[$vdPath] = "v$vdDotNetVersion"
    }
    Return $map
 }
 
