# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Start website, if it exists.
$websitePath = "IIS:\Sites\$websiteName"
if (Test-Path $websitePath) {
    Write-Output "Starting website [$websiteName]."
    Start-Website -Name $websiteName | Out-Null
} else {
    Write-Output "Website [$websiteName] does not exist and will not be started."
}
