# Get provided application path or use the deployed name.
$applicationPath = if($deployed.applicationPath) { $deployed.applicationPath } else { $deployed.name }

# Verify application path and website name are not being changed.
if($previousDeployed) {
    $previousApplicationPath = if($previousDeployed.applicationPath) { $previousDeployed.applicationPath } else { $previousDeployed.name }
    if($applicationPath -ne $previousApplicationPath) {
        Write-Host "Renaming an application is not supported. Undeploy and deploy the application instead."
        Exit 1
    }

    if($deployed.websiteName -ne $previousDeployed.websiteName) {
        Write-Host "Moving an application is not supported. Undeploy and deploy the application instead."
        Exit 1
    }
}

# Create physical path if it doesn't exist yet.
if (!(Test-Path $deployed.physicalPath)) {
    Write-Host "Creating empty application physical path [$($deployed.physicalPath)]."
    if(!(New-Item $deployed.physicalPath -Type Directory -Force)) {
        Write-Host "Cannot create directory [$($deployed.physicalPath)]."
        Exit 1
    }
}

# Check whether application already exists and add -Force if it does.
$appPath = "IIS:\Sites\$($deployed.websiteName)\$applicationPath"
$params = @{ Type="Application"; Path=$appPath; PhysicalPath=$deployed.physicalPath }
if (Test-Path $appPath) {
    Write-Host "Modifying existing application [$applicationPath] in website [$($deployed.websiteName)]."
    $params.Force = $True
} else {
    Write-Host "Creating new application [$applicationPath] in website [$($deployed.websiteName)]."
}

# Create application
New-Item @params | Out-Null

# Set additional application properties.
Set-ItemProperty -path $appPath -name enabledProtocols -value $deployed.protocols
if($deployed.applicationPoolName) {
	Set-ItemProperty -path $appPath -name applicationPool -value $deployed.applicationPoolName
}
