Function inspectApplication($website, $app) {
    $id = $container.id + $app.path
    discovered $id $prototype.type
    inspectedProperty $id "physicalPath" $app.physicalPath
    inspectedProperty $id "websiteName" $website
    inspectedProperty $id "applicationPoolName" $app.applicationPool
    inspectedProperty $id "protocols" $app.enabledProtocols
    inspectedItem $id
}

$websites = Get-Website
if($websites) {
    foreach ($ws in $websites) {
        $apps = Get-WebApplication -Site $ws.name
        if ($apps) {
            if ($apps -is [system.array]) {
                foreach ($app in $apps) {
                    inspectApplication $ws.name $app
                }
            } else {
                inspectApplication $ws.name $apps
            }
        }
    }
}
