Function inspectVirtualDirectory($website, $vd) {
    $id = $container.id + "/" + $vd.path.substring(1)
    discovered $id $prototype.type
    inspectedProperty $id "physicalPath" $vd.physicalPath
    inspectedProperty $id "websiteName" $website
    inspectedItem $id
}

$websites = Get-Website
if($websites) {
    foreach ($ws in $websites) {
        $virtualDirs = Get-WebVirtualDirectory -Site $ws.name
        if ($virtualDirs) {
            if ($virtualDirs -is [system.array]) {
                foreach ($vd in $virtualDirs) {
                    inspectVirtualDirectory $ws.name $vd
                }
            } else {
                inspectVirtualDirectory $ws.name $virtualDirs
            }
        }
    }
}
