$iisVersion = Get-ItemProperty "HKLM:\software\microsoft\InetStp";

if($iisVersion.MajorVersion -lt 7) {
    if($iisVersion.MajorVersion -eq 6) {
        Write-Host "Use the iis6 types for IIS 6.0."
    } else {
        Write-Host "The IIS plugin for Deployit does not support IIS versions below 6.0."
    }
    Exit 1
}

if(($iisVersion.MajorVersion -eq 7) -and ($iisVersion.MinorVersion -eq 0)) {
    Add-PSSnapin WebAdministration
} else {
    Import-Module WebAdministration
}
