# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Start application pool, if it exists and has not already been started.
$applicationPoolPath = "IIS:\AppPools\$applicationPoolName"
if (!(Test-Path $applicationPoolPath)) {
    Write-Host "Application pool [$applicationPoolName] does not exist."
    Exit 1
} elseif((Get-Item $applicationPoolPath).State -eq "Started") {
    Write-Host "Application pool [$applicationPoolName] has already been started."
} else {
    Write-Host "Starting application pool [$applicationPoolName]."
    Start-WebAppPool -Name $applicationPoolName | Out-Null
}
