$appPools = Get-ChildItem IIS:\AppPools
if($appPools) {
    foreach ($ap in $appPools) {
        $id = $container.id + "/" + $ap.name
        discovered $id $prototype.type
        inspectedProperty $id "managedRuntimeVersion" $ap.managedRuntimeVersion
        inspectedProperty $id "enable32BitAppOnWin64" ([string]$ap.enable32BitAppOnWin64).ToLower()
        if ($ap.managedPipelineMode -eq "Classic") {
            inspectedProperty $id "useClassicManagedPipeline" "true"
        }
        inspectedProperty $id "queueLength" $ap.queueLength

        $processModel = $ap.processModel
        inspectedProperty $id "serviceAccount" $processModel.identityType
        if ($processModel.identityType -eq "SpecificUser") {
            inspectedProperty $id "username" $processModel.username
            inspectedProperty $id "password" $processModel.password
        }
        inspectedProperty $id "processModelPingInterval" $processModel.PingInterval.TotalSeconds
        inspectedProperty $id "processModelPingResponseTime" $processModel.PingResponseTime.TotalSeconds
        inspectedProperty $id "processModelStartupTimeLimit" $processModel.StartupTimeLimit.TotalSeconds
        inspectedProperty $id "processModelShutdownTimeLimit" $processModel.ShutdownTimeLimit.TotalSeconds
        inspectedProperty $id "processModelMaxProcesses" $processModel.MaxProcesses
        inspectedProperty $id "processModelIdleTimeout" $processModel.IdleTimeout.TotalMinutes
        inspectedProperty $id "processModelPingEnabled" ([string]$processModel.pingingEnabled).ToLower()

        $failureSettings = $ap.failure
        inspectedProperty $id "failureRapidFailProtection" ([string]$failureSettings.RapidFailProtection).ToLower()
        inspectedProperty $id "failureRapidFailProtectionInterval" $failureSettings.RapidFailProtectionInterval.TotalMinutes
        inspectedProperty $id "failureRapidFailProtectionMaxCrashes" $failureSettings.RapidFailProtectionMaxCrashes

        $recyclingPeriodicRestartScheduleProp =  Get-ItemProperty ("IIS:\AppPools\"+$ap.name) -Name Recycling.periodicRestart.schedule
        $recyclingPeriodicRestartScheduleValue = "";
            if ($recyclingPeriodicRestartScheduleProp.Collection.count -gt 0) {
                $periodicRestartScheduleArray = @()
                $recyclingPeriodicRestartScheduleProp.Collection | foreach {
                    $periodicRestartScheduleArray += $_.value.toString()
                }
                $recyclingPeriodicRestartScheduleValue = [string]::Join(",",$periodicRestartScheduleArray)
            }
        inspectedProperty $id "recyclingPeriodicRestartSchedule" $recyclingPeriodicRestartScheduleValue

        $recyclingSettings = $ap.recycling
        inspectedProperty $id "recyclingPeriodicRestartTime"  $recyclingSettings.PeriodicRestart.Time.TotalMinutes

        inspectedItem $id
    }
}
