/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import org.apache.commons.lang.StringUtils;

public class JbossasRestartServerStep
extends JbossasStepBase {
    private boolean defaultCommand;

    public JbossasRestartServerStep(JbossasServer server) {
        super(server);
        this.defaultCommand = StringUtils.isBlank((String)server.getRestartCommand());
        this.setDescription("Restart JBoss server " + (Object)((Object)server) + (this.defaultCommand ? " (default command)" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            String restartCommand = this.defaultCommand ? this.server.getShutdownCommand() + " -e 10 " : this.server.getRestartCommand();
            ctx.logOutput("Restart command using " + restartCommand);
            String[] restartCommandLine = StringUtils.split((String)restartCommand);
            int res = s.execute((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), restartCommandLine);
            boolean bl = res == 0;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

