package com.xebialabs.deployit.plugin.jbossas.container;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.ci.Container;


@SuppressWarnings("serial")
@Metadata(description = "Base JBoss Server", virtual=true)
public abstract class BaseServer extends Container {
	
	@Property(description="JBoss application server installation directory. e.g. /opt/jboss/5.1.0.GA")
	@InspectionProperty
	private String home;
	
	@Property(defaultValue="default", description="Server configuration name e.g. default or minimal")
	private String serverName;
	
	@Property(required=false, description="JBoss application server version")
	private int version;

	@Property(defaultValue="8080", description="HTTP/1.1 connector port")
	private int httpPort;

	@Property(defaultValue="8009", description="AJP connector port")
	private int ajpPort;

	@Property(defaultValue="1099", description="Connector control port")
	private int controlPort;
	
	@Property(hidden=true, defaultValue="service")
	private String jmsResourceFileSuffix;
	
	protected static final Function<String, Integer> DECODE_VERSION = new Function<String, Integer>() {
		public Integer apply(String input) {
			if (input.contains(".")) {
				String first = Splitter.on(".").split(input).iterator().next();
				Integer integer = Integer.parseInt(first);
				return integer;
			}
			throw new RuntimeException("wrong input value " + input);
		}
	};

	public String getHome() {
    	return home;
    }

	public void setHome(String home) {
    	this.home = home;
    }

	public String getServerName() {
    	return serverName;
    }

	public void setServerName(String serverName) {
    	this.serverName = serverName;
    }

	public int getVersion() {
    	return version;
    }

	public void setVersion(int version) {
    	this.version = version;
    }

	public int getHttpPort() {
    	return httpPort;
    }

	public void setHttpPort(int httpPort) {
    	this.httpPort = httpPort;
    }

	public int getAjpPort() {
    	return ajpPort;
    }

	public void setAjpPort(int ajpPort) {
    	this.ajpPort = ajpPort;
    }

	public int getControlPort() {
    	return controlPort;
    }

	public void setControlPort(int controlPort) {
    	this.controlPort = controlPort;
    }

	public String getJmsResourceFileSuffix() {
    	return jmsResourceFileSuffix;
    }

	public void setJmsResourceFileSuffix(String jmsResourceFileSuffix) {
    	this.jmsResourceFileSuffix = jmsResourceFileSuffix;
    }

	public static Function<String, Integer> getDecodeVersion() {
    	return DECODE_VERSION;
    }

}