/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.container.v6;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.jbossas.container.BaseServer;
import com.xebialabs.deployit.plugin.jbossas.step.SimplePropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleQueryConnectorContainerInspectionStep;

@Metadata(description="JBoss 6.x Server")
public class Server
extends BaseServer {
    @Property(hidden=true, defaultValue="hornetq-jms.xml")
    protected String resourceFileSuffix;
    static final Function<String, String> DECODE_JBOSS_HOME = new Function<String, String>(){

        public String apply(String input) {
            return input.substring(input.indexOf(":") + 1);
        }
    };

    @Inspect
    public void inspect(InspectionPlanningContext ctx) {
        ctx.addStep(new TwiddleContainerInspectionStep(this, "jboss.system:type=ServerConfig", "JBossHome", new SimplePropertyConverter("home", Functions.identity())));
        ctx.addStep(new TwiddleContainerInspectionStep(this, "jboss.system:type=ServerConfig", "ServerName", new SimplePropertyConverter("serverName", Functions.identity())));
        ctx.addStep(new TwiddleContainerInspectionStep(this, "jboss.system:type=Server", "VersionNumber", new SimplePropertyConverter("version", DECODE_VERSION)));
        ctx.addStep(new TwiddleQueryConnectorContainerInspectionStep(this, "jboss.web:type=Connector,*"));
    }
}

