/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.jbossas.step.PropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import java.util.List;
import java.util.Map;

public class TwiddleContainerInspectionStep<T>
extends TwiddleStep
implements InspectionStep {
    private final Map<String, Object> vars = Maps.newHashMap();
    private final PropertyConverter<?> converter;

    public TwiddleContainerInspectionStep(Container deployedJBossResource, String mbean, String attribute, PropertyConverter<?> converter) {
        super(deployedJBossResource, (String)deployedJBossResource.getSyntheticProperty("inspectTemplate"));
        this.converter = converter;
        this.vars.put("container", this.getContainer());
        this.vars.put("mbean", mbean);
        this.vars.put("attribute", attribute);
    }

    public String getDescription() {
        return String.format("Inspect JBoss Server %s/%s", this.vars.get("mbean"), this.vars.get("attribute"));
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        List<String> values = handler.getValues();
        if (values.size() > 1) {
            throw new RuntimeException("Too many answers (" + values.size() + ")" + values);
        }
        this.getContainer().putSyntheticProperty(this.converter.getProperty(), this.converter.getConverter().apply((Object)values.iterator().next()));
    }
}

