/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwiddleStep {
    private transient OverthereConnection remoteConn;
    private transient OverthereFile remoteWorkingDir;
    private final Container container;
    private final String scriptTemplatePath;
    protected InspectionExecutionContext ctx;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public TwiddleStep(Container container, String scriptTemplatePath) {
        this.container = container;
        this.scriptTemplatePath = scriptTemplatePath;
    }

    public Step.Result execute(InspectionExecutionContext ctx) throws Exception {
        this.ctx = ctx;
        String osSpecificTemplate = this.resolveOsSpecificTemplate();
        String executableContent = this.evaluateTemplate(osSpecificTemplate, this.getVars());
        this.logger.debug(executableContent);
        OverthereFile executable = this.uploadExecutable(executableContent, StringUtils.substringAfterLast((String)osSpecificTemplate, (String)"/"));
        CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
        TwiddleProcessOutputHandler parser = new TwiddleProcessOutputHandler();
        MultipleOverthereProcessOutputHandler handle = MultipleOverthereProcessOutputHandler.multiHandler((OverthereProcessOutputHandler[])new OverthereProcessOutputHandler[]{new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)ctx), parser});
        ctx.logOutput("Executing " + executable.getPath() + " on host " + this.container.getHost());
        int rc = this.getRemoteConnection().execute((OverthereProcessOutputHandler)handle, cmdLine);
        if (rc == 0) {
            this.doHandle(parser);
            return Step.Result.Success;
        }
        return Step.Result.Fail;
    }

    protected Map<String, Object> getVars() {
        return Collections.emptyMap();
    }

    protected void doHandle(TwiddleProcessOutputHandler handler) {
    }

    private String resolveOsSpecificTemplate() {
        String scriptExt = StringUtils.substringAfterLast((String)this.scriptTemplatePath, (String)".");
        String osSpecificScript = this.scriptTemplatePath;
        if (StringUtils.isBlank((String)scriptExt)) {
            OperatingSystemFamily os = this.container.getHost().getOs();
            osSpecificScript = osSpecificScript + os.getScriptExtension();
        }
        if (!this.classpathResourceExists(osSpecificScript)) {
            throw new IllegalArgumentException("Resource " + osSpecificScript + " not found in classpath");
        }
        return osSpecificScript;
    }

    private String evaluateTemplate(String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            template.createProcessingEnvironment(vars, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper((FileUploader)new WorkingFolderUploader())).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            this.logger.error("evaluate Template error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getHost().getConnection();
        }
        return this.remoteConn;
    }

    private OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = this.getRemoteConnection().getTempFile("jboss_plugin", ".tmp");
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    private OverthereFile uploadExecutable(String content, String fileName) {
        OverthereFile targetExecutable = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)targetExecutable);
        targetExecutable.setExecutable(true);
        return targetExecutable;
    }

    private boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    public Container getContainer() {
        return this.container;
    }

    private class WorkingFolderUploader
    implements FileUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();

        private WorkingFolderUploader() {
        }

        public String upload(OverthereFile file) {
            if (this.uploadedFiles.containsKey(file.getName())) {
                return this.uploadedFiles.get(file.getName());
            }
            this.uploadedFiles.put(file.getName(), file.getPath());
            return file.getPath();
        }
    }
}

