import re

if re.search(r"\s", deployed.name):
    logErrorAndExit("Deployed name must not contain space, but '%s' contains space." % (deployed.name))


appName = getAppInstallName(deployed.name, "war")
uploadedWar = uploadFile(deployed.file, appName)
#logOutput("Installing war as %s" % (appName))
commandString = ""
if deployed.getProperty("deployToMultipleServerGroups"):
    runtimeName = deployedApplication.name
    envId = deployedApplication.id
    logOutput("Version %s" % deployedApplication.version)
    version = str(deployedApplication.version).split('/')[-1]

    logOutput("Deployed name %s" % deployed.name)
    logOutput("Installing %s version %s war as %s " % (deployedApplication.name, version, runtimeName))
    logOutput("Environment destination %s" %(envId))
    logOutput("Target server groups %s/%s" % (targetServerGroups(), targetServerGroups(True)))
    commandString = 'deploy %s' % (uploadedWar.path)
else:
    commandString = 'deploy %s %s' % (uploadedWar.path, targetServerGroups())

if (deployed.getProperty("contextRoot")):
    commandString += " --runtime-name=%s.war" % deployed.getProperty("contextRoot")
else:
    logOutput("Going to use deployed name for context root")
    commandString += " --runtime-name=%s.war" % deployed.name

if deployed.getProperty("deployToMultipleServerGroups"):
    executionstring = checkDeploymentOnServerGroup(appName, commandString)
else:
    executionstring = commandString

errMsg = executeCmd(executionstring)
if errMsg and resultFailed(errMsg):
    logErrorAndExit(errMsg)
logOutput("Done.")
