/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.container;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.jbossdm.container.CliBasedContainer;
import com.xebialabs.deployit.plugin.jbossdm.container.Mode;
import com.xebialabs.deployit.plugin.jbossdm.container.Profile;
import com.xebialabs.deployit.plugin.jbossdm.container.ServerGroup;
import com.xebialabs.deployit.plugin.jbossdm.step.CliInspectionStep;
import java.util.HashMap;
import java.util.Set;

@Metadata(inspectable=true)
public class Domain
extends CliBasedContainer {
    @Property(required=false, asContainment=true, description="Server groups defined in domain")
    private Set<ServerGroup> serverGroups = Sets.newHashSet();
    @Property(required=false, asContainment=true, description="Profiles defined in domain")
    private Set<Profile> profiles = Sets.newHashSet();

    @Inspect
    public void inspect(InspectionContext ctx) {
        HashMap pyCtx = Maps.newHashMap();
        pyCtx.put("container", this);
        CliInspectionStep step = new CliInspectionStep("jboss/dm/container/inspect-domain.py", 0, pyCtx, "Inspect Domain", this);
        ctx.addStep((Step)step);
    }

    @Override
    public String getTargetServerGroup(boolean undeployment) {
        if (undeployment) {
            return "--all-relevant-server-groups";
        }
        return "--all-server-groups";
    }

    public Set<ServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    public void setServerGroups(Set<ServerGroup> serverGroups) {
        this.serverGroups = serverGroups;
    }

    public Set<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Set<Profile> profiles) {
        this.profiles = profiles;
    }

    @Override
    public Mode getMode() {
        return Mode.DOMAIN;
    }
}

